/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.byteseek.io.IOUtils;
import net.byteseek.io.reader.FileReader;
import net.byteseek.io.reader.cache.WindowCache;

public final class TempFileReader
extends FileReader {
    TempFileReader(InputStream stream) throws IOException {
        this(IOUtils.createTempFile(stream));
    }

    TempFileReader(InputStream stream, int windowSize) throws IOException {
        this(IOUtils.createTempFile(stream), windowSize);
    }

    TempFileReader(InputStream stream, int windowSize, int capacity) throws IOException {
        this(IOUtils.createTempFile(stream), windowSize, capacity);
    }

    TempFileReader(InputStream stream, WindowCache cache) throws IOException {
        this(IOUtils.createTempFile(stream), cache);
    }

    TempFileReader(InputStream stream, int windowSize, WindowCache cache) throws IOException {
        this(IOUtils.createTempFile(stream), windowSize, cache);
    }

    private TempFileReader(File tempFile) throws FileNotFoundException {
        super(tempFile);
    }

    private TempFileReader(File tempFile, int windowSize) throws FileNotFoundException {
        super(tempFile, windowSize);
    }

    private TempFileReader(File tempFile, int windowSize, int capacity) throws FileNotFoundException {
        super(tempFile, windowSize, capacity);
    }

    private TempFileReader(File tempFile, WindowCache cache) throws FileNotFoundException {
        super(tempFile, cache);
    }

    private TempFileReader(File tempFile, int windowSize, WindowCache cache) throws FileNotFoundException {
        super(tempFile, windowSize, cache);
    }

    @Override
    public void close() throws IOException {
        File file = this.getFile();
        try {
            super.close();
        }
        finally {
            boolean fileDeleted = file.delete();
            if (!fileDeleted) {
                throw new IOException("Could not delete the temporary file:" + file.getAbsolutePath());
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[temp file:" + this.getFile() + " length: " + this.getFile().length() + " cache:" + this.cache + ']';
    }
}

