/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.io.IOException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.InvertibleMatcher;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class ByteRangeMatcher
extends InvertibleMatcher {
    private final int minByteValue;
    private final int maxByteValue;

    public ByteRangeMatcher(int minValue, int maxValue, boolean inverted) {
        super(inverted);
        ArgUtils.checkRangeInclusive(minValue, 0, 255, "minValue");
        ArgUtils.checkRangeInclusive(maxValue, 0, 255, "maxValue");
        if (minValue > maxValue) {
            this.minByteValue = maxValue;
            this.maxByteValue = minValue;
        } else {
            this.minByteValue = minValue;
            this.maxByteValue = maxValue;
        }
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        Window window = reader.getWindow(matchPosition);
        if (window != null) {
            int byteValue = window.getByte(reader.getWindowOffset(matchPosition)) & 0xFF;
            boolean insideRange = byteValue >= this.minByteValue && byteValue <= this.maxByteValue;
            return insideRange ^ this.inverted;
        }
        return false;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        if (matchPosition >= 0 && matchPosition < bytes.length) {
            int byteValue = bytes[matchPosition] & 0xFF;
            boolean insideRange = byteValue >= this.minByteValue && byteValue <= this.maxByteValue;
            return insideRange ^ this.inverted;
        }
        return false;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        int byteValue = bytes[matchPosition] & 0xFF;
        boolean insideRange = byteValue >= this.minByteValue && byteValue <= this.maxByteValue;
        return insideRange ^ this.inverted;
    }

    @Override
    public boolean matches(byte theByte) {
        int byteValue = theByte & 0xFF;
        boolean insideRange = byteValue >= this.minByteValue && byteValue <= this.maxByteValue;
        return insideRange ^ this.inverted;
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        StringBuilder regularExpression = new StringBuilder();
        if (this.inverted) {
            regularExpression.append('^');
        }
        String minValue = ByteUtils.byteToString(prettyPrint, this.minByteValue);
        String maxValue = ByteUtils.byteToString(prettyPrint, this.maxByteValue);
        regularExpression.append(String.format("%s-%s", minValue, maxValue));
        return regularExpression.toString();
    }

    @Override
    public byte[] getMatchingBytes() {
        byte[] values = new byte[this.getNumberOfMatchingBytes()];
        if (this.inverted) {
            int value;
            int byteIndex = 0;
            for (value = 0; value < this.minByteValue; ++value) {
                values[byteIndex++] = (byte)value;
            }
            for (value = this.maxByteValue + 1; value < 256; ++value) {
                values[byteIndex++] = (byte)value;
            }
        } else {
            int byteIndex = 0;
            for (int value = this.minByteValue; value <= this.maxByteValue; ++value) {
                values[byteIndex++] = (byte)value;
            }
        }
        return values;
    }

    @Override
    public int getNumberOfMatchingBytes() {
        return this.inverted ? 255 - this.maxByteValue + this.minByteValue : this.maxByteValue - this.minByteValue + 1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[start:" + this.minByteValue + " end: " + this.maxByteValue + " inverted:" + this.inverted + ']';
    }
}

