/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.sequence;

import java.io.IOException;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.searcher.sequence.AbstractSequenceSearcher;

public final class SequenceMatcherSearcher
extends AbstractSequenceSearcher {
    public SequenceMatcherSearcher(SequenceMatcher sequence) {
        super(sequence);
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        SequenceMatcher sequence = this.matcher;
        int lastPossiblePosition = bytes.length - sequence.length();
        int lastPosition = toPosition < lastPossiblePosition ? toPosition : lastPossiblePosition;
        int n = searchPosition = fromPosition > 0 ? fromPosition : 0;
        while (searchPosition <= lastPosition) {
            if (sequence.matchesNoBoundsCheck(bytes, searchPosition)) {
                return SearchUtils.singleResult(searchPosition, sequence);
            }
            ++searchPosition;
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        long searchPosition;
        SequenceMatcher sequence = this.matcher;
        long l = searchPosition = fromPosition > 0L ? fromPosition : 0L;
        while (searchPosition <= toPosition && (window = reader.getWindow(searchPosition)) != null) {
            long lastPosition;
            int searchLength = window.length() - reader.getWindowOffset(searchPosition);
            long endWindowPosition = searchPosition + (long)searchLength - 1L;
            long l2 = lastPosition = endWindowPosition < toPosition ? endWindowPosition : toPosition;
            while (searchPosition <= lastPosition) {
                if (sequence.matches(reader, searchPosition)) {
                    return SearchUtils.singleResult(searchPosition, sequence);
                }
                ++searchPosition;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        SequenceMatcher sequence = this.matcher;
        int lastPosition = toPosition > 0 ? toPosition : 0;
        int firstPossiblePosition = bytes.length - sequence.length();
        int n = searchPosition = fromPosition < firstPossiblePosition ? fromPosition : firstPossiblePosition;
        while (searchPosition >= lastPosition) {
            if (sequence.matchesNoBoundsCheck(bytes, searchPosition)) {
                return SearchUtils.singleResult(searchPosition, sequence);
            }
            --searchPosition;
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        SequenceMatcher sequence = this.matcher;
        long searchPosition = this.withinLength(reader, fromPosition);
        while (searchPosition >= toPosition && (window = reader.getWindow(searchPosition)) != null) {
            long lastSearchPosition;
            long windowStartPosition = window.getWindowPosition();
            long l = lastSearchPosition = toPosition > windowStartPosition ? toPosition : windowStartPosition;
            while (searchPosition >= lastSearchPosition) {
                if (sequence.matches(reader, searchPosition)) {
                    return SearchUtils.singleResult(searchPosition, sequence);
                }
                --searchPosition;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public void prepareForwards() {
    }

    @Override
    public void prepareBackwards() {
    }
}

