/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public class TiffProfileDNG
extends TiffProfile {
    public static final int CFA = 32803;
    public static final int LINEAR_RAW = 34892;
    private boolean asShotNeutralSeen;
    private boolean asShotWhiteXYSeen;

    public TiffProfileDNG() {
        this._profileText = "DNG 1.0.0.0 (September 2004)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int pInterpretation = niso.getColorSpace();
        if (pInterpretation != 32803 && pInterpretation != 34892) {
            return false;
        }
        int[] bps = niso.getBitsPerSample();
        if (bps != null) {
            int bpsval = bps[0];
            if (bpsval < 8 || bpsval > 32) {
                return false;
            }
            for (int i = 0; i < bps.length; ++i) {
                if (bpsval == bps[i]) continue;
                return false;
            }
        }
        if (pInterpretation == 32803 && (tifd.getCFAPlaneColor() == null || tifd.getCFARepeatPatternDim() == null || tifd.getCFAPattern() == null)) {
            return false;
        }
        if (niso.getOrientation() == -1) {
            return false;
        }
        int compression = niso.getCompressionScheme();
        return compression == -1 || compression == 1 || compression == 7;
    }
}

