/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.utils;

import com.exlibris.core.infra.common.cache.SessionUtils;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.common.util.ResourceBundleUtil;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.exceptions.DepositProcessingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVStrategy;
import org.apache.commons.csv.CSVUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class CSVUtil {
    private static final ExLogger log = ExLogger.getExLogger(CSVUtil.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String COLLECTIONS_CSV = "collections.csv";
    public static final String UNIQE_METS_PATH_KEY = "uniqueMetsPathKey";
    public static final String REPRESENTATION = "REPRESENTATION";
    public static final String COLLECTION_NAME = "Collection Name";
    public static final String COLLECTION_PATH = "Collection Path";
    public static final String CSV_EXTENTION = ".csv";
    public static final String SIP = "SIP";
    public static final String COLLECTION = "Collection";
    public static final String IE = "IE";
    public static final String REP = "REP";
    public static final String FILE = "File";
    public static final String SELECTED_CSV_TEMPLATE_PARAMETER = "selected_mapping_table";
    public static final String SELECTED_GENERATE_CSV_OPTION_PARAMETER = "generate_csv_option";
    public static final String SELECTED_CSV_TEMPLATE = "selectedMappingTable";
    public static final String SIMPLE_CSV_OPTION = "Simple";
    public static final String COMPLEX_CSV_OPTION = "Complex";
    public static final String SIMPLE_COLLECTIONS_CSV_OPTION = "SimpleCollections";
    public static final String OBJECT_TYPE = "Object Type";
    public static final String FILE_ORIGINAL_NAME = "File Original Name";
    public static final String FILE_ORIGINAL_PATH = "File Original Path";
    public static final String FILE_NAME = "File Name";
    public static final String FILE_LOCATION = "File Location";
    public static final String COLLECTION_IS_PART_OF = "Is Part Of (DCTERMS)";
    public static final String COLLECTION_TITLE = "Title (DC)";
    public static final String DC_TITLE = "dc:title";
    public static final String DCTERMS_IS_PART_OF = "dcterms:isPartOf";
    public static final String DNX_FILE_ORIGINAL_NAME = "dnx.generalFileCharacteristics.fileOriginalName";
    public static final String DNX_FILE_ORIGINAL_PATH = "dnx.generalFileCharacteristics.fileOriginalPath";
    public static final String COLLECTION_EXTERNAL_SYSTEM = "collection.externalSystem";
    public static final String COLLECTION_EXTERNAL_ID = "collection.externalId";
    public static final String COLLECTION_DESCRIPTION = "collection.description";
    public static final String COLLECTION_PUBLISH = "collection.publish";
    public static final String COLLECTION_NAVIGATE = "collection.navigate";
    public static final String EVENT = "event";

    public static List<String[]> readFile(File f, boolean hasHeaderRow) throws Exception {
        if (!f.exists()) {
            throw new FileNotFoundException("Unable to read file: " + f.getName());
        }
        log.info("Reading CSV file: " + f.getName());
        String content = "";
        ArrayList<String[]> values = new ArrayList<String[]>();
        try {
            content = FileUtil.getContents(f, "UTF-8");
            if (StringUtils.isEmptyString(content)) {
                throw new Exception("CSV file contains no content " + f.getName());
            }
        }
        catch (Exception e) {
            throw new Exception("Error occured while parsing CSV file " + f.getName() + "\nCause: " + e.toString());
        }
        try {
            for (String[] lines : CSVUtils.parse((String)content)) {
                StringBuilder builder = new StringBuilder();
                for (String s : lines) {
                    builder.append(org.apache.commons.lang3.StringEscapeUtils.escapeCsv((String)s)).append(",");
                }
                builder.deleteCharAt(builder.length() - 1);
                if (StringUtils.isEmptyString(builder.toString())) continue;
                try {
                    String[] parsedLine = CSVUtils.parseLine((String)builder.toString());
                    CSVUtil.unescapeValues(parsedLine);
                    values.add(parsedLine);
                }
                catch (Exception e) {
                    log.error("Unable to read CSV line: " + lines[0], new String[0]);
                }
            }
        }
        catch (Exception e) {
            log.error("Error occured while parsing CSV file " + f.getName() + "\nCause: " + e.toString(), new String[0]);
            throw new DepositProcessingException(DescriptorConstants.DP_ErrorParsingDescriptiveCsv, (Object)f.getName(), e);
        }
        log.info("Finished reading CSV file: " + f.getName());
        return values;
    }

    public static List<String[]> readFile(String filename, boolean hasHeaderRow) throws Exception {
        return CSVUtil.readFile(new File(filename), hasHeaderRow);
    }

    public static void writeFile(File f, List<String[]> values, String[] headerRow, boolean escapeValues) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (headerRow != null) {
            sb.append(CSVUtil.getAsString(headerRow, escapeValues)).append(LINE_SEPARATOR);
        }
        if (values != null) {
            for (String[] row : values) {
                sb.append(CSVUtil.getAsString(row, escapeValues)).append(LINE_SEPARATOR);
            }
        }
        FileUtil.writeFile(f, sb.toString());
    }

    public static void appendFile(File f, List<String[]> values, boolean escapeValues) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (String[] row : values) {
            sb.append(CSVUtil.getAsString(row, escapeValues)).append(LINE_SEPARATOR);
        }
        FileUtil.writeFile(f, sb.toString(), true);
    }

    public static void appendFile(String filename, List<String[]> values) throws Exception {
        CSVUtil.appendFile(filename, values, true);
    }

    public static void appendFile(String filename, List<String[]> values, boolean escapeValues) throws Exception {
        CSVUtil.appendFile(new File(filename), values, escapeValues);
    }

    public static void appendStringFile(File f, List<String[]> values, boolean escapeValues) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (String[] row : values) {
            sb.append(CSVUtil.getAsString(row, escapeValues)).append(LINE_SEPARATOR);
        }
        FileUtil.writeFile(f, sb.toString(), true);
    }

    public static void appendStringFile(String filename, List<String[]> values) throws Exception {
        CSVUtil.appendStringFile(filename, values, true);
    }

    public static void appendStringFile(String filename, List<String[]> values, boolean escapeValues) throws Exception {
        CSVUtil.appendStringFile(new File(filename), values, escapeValues);
    }

    public static void writeFile(File f, List<String[]> values, boolean escapeValues) throws Exception {
        CSVUtil.writeFile(f, values, null, escapeValues);
    }

    public static void writeFile(String filename, List<String[]> values, String[] headerRow) throws Exception {
        CSVUtil.writeFile(filename, values, headerRow, true);
    }

    public static void writeFile(String filename, List<String[]> values, String[] headerRow, boolean escapeValues) throws Exception {
        CSVUtil.writeFile(new File(filename), values, headerRow, escapeValues);
    }

    public static void writeFile(String filename, List<String[]> values, boolean escapeValues) throws Exception {
        CSVUtil.writeFile(new File(filename), values, null, escapeValues);
    }

    public static String getAsString(String[] values, boolean escapeValues) {
        if (values == null || values.length == 0) {
            return "";
        }
        if (escapeValues) {
            CSVUtil.escapeValues(values);
        }
        String line = CSVUtils.printLine((String[])values);
        line = CSVUtil.replaceNull(line);
        return line;
    }

    private static String replaceNull(String line) {
        line = line.replaceAll(CSVStrategy.DEFAULT_STRATEGY.getDelimiter() + "null", CSVStrategy.DEFAULT_STRATEGY.getDelimiter() + "");
        return line;
    }

    private static void escapeValues(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = StringEscapeUtils.escapeJava((String)values[i]);
        }
    }

    private static void unescapeValues(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = StringEscapeUtils.unescapeJava((String)values[i]);
        }
    }

    public static Map<String, String> convertRowToMap(String[] csvRow, String[] csvLabels) {
        LinkedHashMap<String, String> csvRowHash = new LinkedHashMap<String, String>();
        for (int j = 0; j < csvRow.length; ++j) {
            if (org.apache.commons.lang.StringUtils.isEmpty((String)csvRow[j])) continue;
            if (csvRowHash.get(csvLabels[j]) == null) {
                csvRowHash.put(csvLabels[j], csvRow[j]);
                continue;
            }
            csvRowHash.put(csvLabels[j] + "_" + j, csvRow[j]);
        }
        return csvRowHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadCsvFile(HttpServletResponse response, String[] csvLabels, List<String[]> csvList, String fileLocation) throws Exception, FileNotFoundException, IOException {
        CSVUtil.writeFile(fileLocation, csvList, csvLabels);
        FileInputStream in = null;
        ServletOutputStream out = null;
        try {
            File file = new File(fileLocation);
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "public");
            response.setContentType("text/csv");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + FilenameUtils.getName((String)fileLocation) + "\"");
            in = new FileInputStream(file);
            response.setContentLength(in.available());
            out = response.getOutputStream();
            byte[] outputByte = new byte[4096];
            while (in.read(outputByte, 0, 4096) != -1) {
                out.write(outputByte, 0, 4096);
            }
            out.flush();
            response.flushBuffer();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(out);
            throw throwable;
        }
        IOUtil.closeQuietly(in);
        IOUtil.closeQuietly((OutputStream)out);
    }

    public static String convertXpathToFieldName(String objectTypePrefix, String xpath) {
        String fieldName = objectTypePrefix;
        if (xpath.startsWith("collection.")) {
            fieldName = xpath;
        } else if (xpath.startsWith("dnx.")) {
            fieldName = fieldName + xpath.substring(xpath.indexOf(".") + 1);
        } else {
            if (xpath.contains("@xsi:type=\"")) {
                xpath = xpath.replace("@xsi:type=\"", ":");
                xpath = xpath.replace("\"", "");
            }
            xpath = xpath.replace(":", ".");
            fieldName = fieldName + xpath;
        }
        return fieldName;
    }

    public static String getLabelByXpathAndObjectType(String objectType2, String xpath) {
        String objectTypePrefix = SIP.equals(objectType2) || "COLLECTION".equals(objectType2) ? IE : objectType2;
        objectTypePrefix = REPRESENTATION.equals(objectTypePrefix) ? REP : objectTypePrefix;
        objectTypePrefix = objectTypePrefix + ".";
        String fieldName = CSVUtil.convertXpathToFieldName(objectTypePrefix, xpath);
        Locale locale = new Locale(SessionUtils.getSessionLanguage());
        ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(locale);
        return ResourceBundleUtil.getString(resourceBundle, fieldName, false);
    }

    public static List<String> getCollectionExtraFields() {
        ArrayList<String> collectionExtraFields = new ArrayList<String>();
        collectionExtraFields.add(COLLECTION_EXTERNAL_SYSTEM);
        collectionExtraFields.add(COLLECTION_EXTERNAL_ID);
        collectionExtraFields.add(COLLECTION_DESCRIPTION);
        collectionExtraFields.add(COLLECTION_PUBLISH);
        collectionExtraFields.add(COLLECTION_NAVIGATE);
        return collectionExtraFields;
    }
}

