/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid6;

public final class FragmentRewriter {
    private static final char INVERTED_OLD = '!';
    private static final char INVERTED_NEW = '^';
    private static final char RANGE_OLD = ':';
    private static final char RANGE_NEW = '-';
    private static final char QUOTE = '\'';
    private static final char BACKTICK = '`';
    private static final char OPENSET = '[';
    private static final char CLOSESET = ']';

    private FragmentRewriter() {
    }

    public static String rewriteFragment(String fragment) {
        StringBuilder builder = new StringBuilder();
        int length = fragment.length();
        boolean inCaseSensitiveString = false;
        boolean inCaseInsensitiveString = false;
        int inSet = 0;
        for (int charIndex = 0; charIndex < length; ++charIndex) {
            char theChar = fragment.charAt(charIndex);
            if (!inCaseSensitiveString && !inCaseInsensitiveString) {
                if (inSet > 0) {
                    if (theChar == ':') {
                        builder.append('-');
                    } else if (theChar != '!') {
                        builder.append(theChar);
                    }
                } else if (theChar == '[' && charIndex + 1 < length && fragment.charAt(charIndex + 1) == '!') {
                    builder.append('^').append('[');
                } else {
                    builder.append(theChar);
                }
            } else {
                builder.append(theChar);
            }
            if (theChar == '\'' && !inCaseInsensitiveString) {
                inCaseSensitiveString = !inCaseSensitiveString;
                continue;
            }
            if (theChar == '`' && !inCaseSensitiveString) {
                inCaseInsensitiveString = !inCaseInsensitiveString;
                continue;
            }
            if (inCaseSensitiveString || inCaseInsensitiveString) continue;
            if (theChar == '[') {
                ++inSet;
                continue;
            }
            if (theChar != ']') continue;
            --inSet;
        }
        return builder.toString();
    }
}

