/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.api.version;

import com.exlibris.core.infra.model.HPersistent;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="APPLICATION_VERSION")
@UniqueConstraint(columnNames={"serverName"})
@NamedQueries(value={@NamedQuery(name="APP_VERSIONS_BY_SERVER_ROLE", query="from ApplicationVersion AV where serverRole like :serverRole  and version = (select max(version) from ApplicationVersion) order by serverName"), @NamedQuery(name="APP_VERSIONS_LAST_VERSION", query="from ApplicationVersion AV where version = (select max(version) from ApplicationVersion) order by serverName"), @NamedQuery(name="LAST_VERSION", query="select max(version) from ApplicationVersion")})
public class ApplicationVersion
extends HPersistent {
    private static final long serialVersionUID = 1L;
    public static final String APP_VERSIONS_BY_SERVER_ROLE = "APP_VERSIONS_BY_SERVER_ROLE";
    public static final String APP_VERSIONS_LAST_VERSION = "APP_VERSIONS_LAST_VERSION";
    public static final String APP_LAST_VERSION = "LAST_VERSION";
    private String serverName;
    private String serverRole;
    private Boolean dbUpdated;
    private String version;
    private Calendar buildDate;
    private String buildNumber;
    private Integer rank;

    @Column(name="SERVER_NAME")
    public String getServerName() {
        return this.serverName;
    }

    @Column(name="SERVER_ROLE")
    public String getServerRole() {
        return this.serverRole;
    }

    @Column(name="VERSION")
    public String getVersion() {
        return this.version;
    }

    @OrderBy
    @Column(name="BUILD_DATE")
    public Calendar getBuildDate() {
        return this.buildDate;
    }

    @Column(name="DB_UPDATED")
    public Boolean getDbUpdated() {
        return this.dbUpdated;
    }

    @Column(name="BUILD_NUMBER")
    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerRole(String serverRole) {
        this.serverRole = serverRole;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBuildDate(Calendar buildDate) {
        this.buildDate = buildDate;
    }

    public void setDbUpdated(Boolean dbUpdated) {
        this.dbUpdated = dbUpdated;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getRank() {
        return this.rank;
    }
}

