/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.common;

import com.exlibris.core.infra.common.cache.SessionUtils;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.ResourceBundleUtil;
import com.exlibris.core.infra.common.util.SynchronizedDateFormat;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;

public class DateHandler {
    public static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String DEFAULT_TIME_FORMAT = "hh:mm:ss z";
    public static final String SYSTEM_DATE_FORMAT = "system_date_format";
    public static final String SYSTEM_TIME_FORMAT = "system_time_format";
    private static SynchronizedDateFormat timeFormatter = null;
    private static SynchronizedDateFormat dateFormatter = null;
    private static SynchronizedDateFormat internalDateFormatter = null;
    private static SynchronizedDateFormat timestampDateFormatter = null;
    public static String dateFormat = null;
    public static String timeFormat = null;
    public static String internalDateFormat = "yyyy-MM-dd HH:mm:ss";
    public static String timestampDateFormat = "yyyyMMdd_HHmmss";
    public static String timeStamp = "EEE MMM dd hh:mm:ss zzz yyyy";
    public static String xmlDateFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static String xmlDateFormatWithMS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static String yearDateFormat = "yyyy";
    public static String dnxDateFormat = "dd/MM/yyyy HH:mm:SS";
    private static SynchronizedDateFormat dnxDateFormatter = new SynchronizedDateFormat(dnxDateFormat);
    public static SimpleDateFormat RetentionPolicyDateFormat = null;
    private static final ExLogger logger = ExLogger.getExLogger(DateHandler.class);

    public static void reset() {
        DateHandler.init();
    }

    private static void init() {
        try {
            GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            DateHandler.loadDateFormat(gpm);
            DateHandler.loadTimeFormat(gpm);
            internalDateFormatter = new SynchronizedDateFormat(internalDateFormat);
            timestampDateFormatter = new SynchronizedDateFormat(timestampDateFormat);
            RetentionPolicyDateFormat = new SimpleDateFormat(DateHandler.getDateFormat() + DateHandler.getTimeFormat());
        }
        catch (Throwable tr) {
            logger.error("Failed to reload DateHandler", tr, new String[0]);
        }
    }

    private static void loadTimeFormat(GeneralParameterManager gpm) {
        timeFormat = gpm.getParameter("general", SYSTEM_TIME_FORMAT);
        if (StringUtils.isBlank((String)timeFormat)) {
            timeFormat = DEFAULT_TIME_FORMAT;
        }
        timeFormatter = new SynchronizedDateFormat(timeFormat);
    }

    private static void loadDateFormat(GeneralParameterManager gpm) {
        dateFormat = gpm.getParameter("repository", SYSTEM_DATE_FORMAT);
        if (StringUtils.isBlank((String)dateFormat)) {
            dateFormat = DEFAULT_DATE_FORMAT;
        }
        dateFormatter = new SynchronizedDateFormat(dateFormat);
    }

    public static String getDateFormat() {
        return dateFormat;
    }

    public static String getTimeFormat() {
        return timeFormat;
    }

    public static SimpleDateFormat getDateFormatter() {
        return dateFormatter.getDateFormatClone();
    }

    public static SimpleDateFormat getTimeFormatter() {
        return timeFormatter.getDateFormatClone();
    }

    public static Calendar getDate(String strDate) throws ParseException {
        Date date = new Date();
        if ((strDate = strDate.trim()).length() < 11) {
            strDate = strDate + " 00:00:00";
        }
        date = internalDateFormatter.parse(strDate);
        Calendar cal = null;
        cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Date getInternalDate(String strDate) throws ParseException {
        return internalDateFormatter.parse(strDate);
    }

    public static Date getDnxDate(String strDate) throws ParseException {
        return dnxDateFormatter.parse(strDate);
    }

    public static String getDateStringFormat(String strDate) throws ParseException {
        Date date = new Date();
        String dateString = null;
        date = internalDateFormatter.parse(strDate);
        dateString = internalDateFormatter.format(date);
        return dateString;
    }

    public static String getStringFormatFromCalendar(Calendar cal) {
        if (cal == null) {
            return null;
        }
        Date d = cal.getTime();
        String dateString = internalDateFormatter.format(d);
        return dateString;
    }

    public static Date parseDateByFormat(String strDate) throws ParseException {
        return DateHandler.parseDateByFormat(strDate, true);
    }

    public static Date parseDateByFormat(String strDate, boolean lenient) throws ParseException {
        dateFormatter.setLenient(lenient);
        Date date = dateFormatter.parse(strDate);
        return date;
    }

    public static String formatDate(Date date) {
        try {
            String strd = dateFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatTime(Date date) {
        try {
            String strd = timeFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatDateAndTime(Date date) {
        try {
            String strd = dateFormatter.format(date) + " " + timeFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parseDateAndTime(String dateTime) {
        try {
            return timeFormatter.parse(dateTime);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static String formatDateAndTimeAsString(Date date) {
        String strd = "";
        if (date == null) {
            return strd;
        }
        try {
            strd = dateFormatter.format(date) + " " + timeFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTimestamp(Date date) {
        String strd = "";
        if (date == null) {
            return strd;
        }
        try {
            strd = timestampDateFormatter.format(date);
            return strd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static java.sql.Date parseDate(String content) {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        ArrayList<String> dateFormats = new ArrayList<String>();
        String dateFormatsStr = null;
        GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        dateFormatsStr = gpm.getParameter("search", "index_supported_date_formats");
        if (StringUtils.isNotBlank((String)dateFormatsStr)) {
            for (String format : dateFormatsStr.split(",")) {
                if (dateFormats.contains(format.trim())) continue;
                dateFormats.add(format.trim());
            }
        }
        dateFormats.add(xmlDateFormat);
        dateFormats.add(xmlDateFormatWithMS);
        dateFormats.add(yearDateFormat);
        dateFormats.add(timeStamp);
        if (dateFormat != null) {
            dateFormats.add(dateFormat);
        }
        if (internalDateFormat != null) {
            dateFormats.add(internalDateFormat);
        }
        String defaultDateFormatsStr = "yyyy-MM-dd HH:mm:ss, yyyy-MM-dd, dd/MM/yyyy";
        for (String string : defaultDateFormatsStr.split(",")) {
            if (dateFormats.contains(string.trim())) continue;
            dateFormats.add(string.trim());
        }
        Date date = null;
        for (String formatStr : dateFormats) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatStr, new Locale(SessionUtils.getSessionLanguage()));
            try {
                date = simpleDateFormat.parse(content);
                return new java.sql.Date(date.getTime());
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static String dateDiffAsString(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return "";
        }
        long diffMillis = d2.getTime() - d1.getTime();
        long hours = diffMillis / 3600000L;
        long minutes = diffMillis / 60000L % 60L;
        long seconds = diffMillis / 1000L % 60L;
        Locale locale = new Locale(SessionUtils.getSessionLanguage());
        ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(locale);
        String hourStr = ResourceBundleUtil.getString(resourceBundle, "c.label.hour");
        String minStr = ResourceBundleUtil.getString(resourceBundle, "c.label.minute");
        String secStr = ResourceBundleUtil.getString(resourceBundle, "c.label.second");
        String hoursStr = (hours < 10L ? "0" : "") + hours + hourStr;
        String minutesStr = (minutes < 10L ? "0" : "") + minutes + minStr;
        String secondsStr = (seconds < 10L ? "0" : "") + seconds + secStr;
        return hoursStr + " " + minutesStr + " " + secondsStr;
    }

    static {
        DateHandler.init();
    }
}

