/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.sdk.mimetypes.MimeTypeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class FileTransferUtil {
    private static final String UPLOAD_TO_CLIENT_BINARY = "application/octet-stream";
    public static final String HTTP_SCHEMA = "http";
    public static final String FILE_SCHEMA = "file";
    public static final String UTF8 = "UTF-8";

    public static String decodeURL(String url) throws UnsupportedEncodingException {
        return URLDecoder.decode(url, UTF8);
    }

    public static String encodeURL(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, UTF8);
    }

    public static String getUrlFileExtension(String pUrl) throws IOException {
        if (pUrl == null) {
            throw new IOException("Url is null ");
        }
        if (!FileTransferUtil.isUrlValid(pUrl = FileTransferUtil.assureHttpPrefix(pUrl))) {
            throw new IOException("Url is invalid " + pUrl);
        }
        URL url = new URL(pUrl);
        String contentType = url.openConnection().getContentType();
        if (contentType != null && contentType.indexOf(";") != -1) {
            contentType = contentType.substring(0, contentType.indexOf(";"));
        }
        return MimeTypeUtil.getMimeTypeUtil().getFileExtension(contentType);
    }

    public static String getUrlMimeType(String pUrl) throws IOException {
        if (pUrl == null) {
            throw new IOException("Url is null ");
        }
        URL url = new URL(pUrl = FileTransferUtil.assureHttpPrefix(pUrl));
        String contentType = url.openConnection().getContentType();
        if (contentType != null && contentType.indexOf(";") != -1) {
            contentType = contentType.substring(0, contentType.indexOf(";"));
        }
        return contentType;
    }

    public static byte[] getHttpUrlByteContent(String pUrl) throws IOException {
        if (pUrl == null) {
            return null;
        }
        URL url = new URL(pUrl = FileTransferUtil.assureHttpPrefix(pUrl));
        String schema = url.getProtocol();
        if (schema != null && !schema.startsWith(HTTP_SCHEMA)) {
            return null;
        }
        InputStream urlInput = url.openStream();
        byte[] ret = IOUtil.toByteArray(urlInput);
        urlInput.close();
        return ret;
    }

    public static byte[] getUrlByteContent(String pUrl) throws IOException {
        InputStream iStream = FileTransferUtil.getUrlContent(pUrl);
        if (iStream != null) {
            return IOUtil.toByteArray(iStream);
        }
        return null;
    }

    public static InputStream getUrlContent(String pUrl) throws IOException {
        return FileTransferUtil.getUrlContent(pUrl, null, null);
    }

    public static synchronized InputStream getUrlContent(String pUrl, String user, String password) throws IOException {
        if (pUrl == null) {
            return null;
        }
        if (user != null && password != null) {
            Authenticator.setDefault(new SiteAuthenticator(user, password));
        }
        if (pUrl.startsWith(FILE_SCHEMA) || new File(pUrl).exists()) {
            if (pUrl.startsWith(FILE_SCHEMA)) {
                pUrl = pUrl.substring(FILE_SCHEMA.length() + "://".length());
            }
            return new BufferedInputStream(new FileInputStream(pUrl));
        }
        BufferedInputStream in = null;
        pUrl = FileTransferUtil.assureHttpPrefix(pUrl);
        URL url = new URL(pUrl);
        try {
            in = new BufferedInputStream(url.openStream());
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return in;
    }

    public static boolean isUrlValid(String pUrl) {
        try {
            URL url = new URL(pUrl);
            InputStream is = url.openStream();
            is.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isUrlReturnsOkStatus(String pUrl) {
        try {
            URL url = new URL(pUrl);
            HttpURLConnection.setFollowRedirects(true);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            if (con.getResponseCode() == 200) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String assureHttpPrefix(String url) {
        if (url == null) {
            return null;
        }
        if (!url.startsWith(HTTP_SCHEMA) && url.indexOf("://") < 0) {
            url = "http://" + url;
        }
        return url;
    }

    public static int getUrlStatus(String urlString, boolean followRedirect) throws IOException {
        int response = -1;
        URL url = new URL(urlString);
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setInstanceFollowRedirects(followRedirect);
            httpConnection.setRequestMethod("HEAD");
            httpConnection.connect();
            response = httpConnection.getResponseCode();
        }
        return response;
    }

    public static String getUrlStatusMsg(String urlString, boolean followRedirect) throws IOException {
        String response = "";
        URL url = new URL(urlString);
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setInstanceFollowRedirects(followRedirect);
            httpConnection.setRequestMethod("HEAD");
            httpConnection.connect();
            response = "" + httpConnection.getResponseCode();
            String msg = httpConnection.getResponseMessage();
            if (msg != null && msg.length() > 0) {
                response = response + " - " + msg;
            }
        }
        return response;
    }

    private static class SiteAuthenticator
    extends Authenticator {
        private String username = null;
        private String password = null;

        public SiteAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String promptString = this.getRequestingPrompt();
            String hostname = this.getRequestingHost();
            InetAddress ipaddr = this.getRequestingSite();
            int port = this.getRequestingPort();
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }
}

