/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.dnx;

import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxSection;
import com.exlibris.digitool.common.dnx.DnxSectionRecord;
import java.util.List;

public class PronomDocumentHelper {
    private DnxDocument document = null;

    public PronomDocumentHelper(DnxDocument document) {
        this.document = document;
    }

    public DnxDocument getDocument() {
        return this.document;
    }

    public void setDocument(DnxDocument document) {
        this.document = document;
    }

    public PronomRegistry getPronomRegistry() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("PronomRegistry");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        PronomRegistry object = new PronomRegistry();
        DnxSectionRecord dnxSectionRecord = recordList.get(0);
        object.setId(dnxSectionRecord.getSectionKeyValue("id"));
        object.setPuid(dnxSectionRecord.getSectionKeyValue("puid"));
        object.setName(dnxSectionRecord.getSectionKeyValue("name"));
        object.setVersion(dnxSectionRecord.getSectionKeyValue("version"));
        object.setMimeType(dnxSectionRecord.getSectionKeyValue("mimeType"));
        object.setInternalSignatureList(dnxSectionRecord.getSectionKeyValue("internalSignatureList"));
        object.setExtensionList(dnxSectionRecord.getSectionKeyValue("extensionList"));
        object.setHasPriorityOverList(dnxSectionRecord.getSectionKeyValue("hasPriorityOverList"));
        return object;
    }

    public void setPronomRegistry(PronomRegistry obj) {
        this.document.deleteSection("PronomRegistry");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("PronomRegistry");
            dnxSection.updateSectionKey("id", obj.getId());
            dnxSection.updateSectionKey("puid", obj.getPuid());
            dnxSection.updateSectionKey("name", obj.getName());
            dnxSection.updateSectionKey("version", obj.getVersion());
            dnxSection.updateSectionKey("mimeType", obj.getMimeType());
            dnxSection.updateSectionKey("internalSignatureList", obj.getInternalSignatureList());
            dnxSection.updateSectionKey("extensionList", obj.getExtensionList());
            dnxSection.updateSectionKey("hasPriorityOverList", obj.getHasPriorityOverList());
        }
    }

    public class PronomRegistry {
        private String id;
        private String puid;
        private String name;
        private String version;
        private String mimeType;
        private String internalSignatureList;
        private String extensionList;
        private String hasPriorityOverList;

        public PronomRegistry() {
        }

        public PronomRegistry(String id, String puid, String name, String version, String mimeType, String internalSignatureList, String extensionList, String hasPriorityOverList) {
            this.setId(id);
            this.setPuid(puid);
            this.setName(name);
            this.setVersion(version);
            this.setMimeType(mimeType);
            this.setInternalSignatureList(internalSignatureList);
            this.setExtensionList(extensionList);
            this.setHasPriorityOverList(hasPriorityOverList);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String s) {
            this.id = s;
        }

        public String getPuid() {
            return this.puid;
        }

        public void setPuid(String s) {
            this.puid = s;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String s) {
            this.name = s;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String s) {
            this.version = s;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String s) {
            this.mimeType = s;
        }

        public String getInternalSignatureList() {
            return this.internalSignatureList;
        }

        public void setInternalSignatureList(String s) {
            this.internalSignatureList = s;
        }

        public String getExtensionList() {
            return this.extensionList;
        }

        public void setExtensionList(String s) {
            this.extensionList = s;
        }

        public String getHasPriorityOverList() {
            return this.hasPriorityOverList;
        }

        public void setHasPriorityOverList(String s) {
            this.hasPriorityOverList = s;
        }
    }
}

