/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.utils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.strings.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import jxl.Cell;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class JxlUtil {
    private static final ExLogger log = ExLogger.getExLogger(JxlUtil.class);

    public static ByteArrayOutputStream writeStream(String sheetName, List<List<String>> rows) throws Exception {
        ByteArrayOutputStream jxlstream = new ByteArrayOutputStream();
        WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)jxlstream);
        WritableSheet sheet = workbook.createSheet(sheetName, 0);
        int rowNumber = 0;
        for (List<String> columns : rows) {
            int columnNumber = 0;
            for (String column : columns) {
                Label label = new Label(columnNumber++, rowNumber, column);
                sheet.addCell((WritableCell)label);
            }
            ++rowNumber;
        }
        workbook.write();
        workbook.close();
        return jxlstream;
    }

    public static boolean isEmptyRow(Cell[] cells) {
        if (cells == null) {
            return true;
        }
        if (cells.length == 0) {
            return true;
        }
        for (Cell cell : cells) {
            String content = cell.getContents();
            if (StringUtils.isEmptyString(content)) continue;
            return false;
        }
        return true;
    }
}

