/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITCTP2
extends TiffProfileClassIT {
    public TiffProfileClassITCTP2() {
        this._profileText = "TIFF/IT-CT/P2 (ISO 12639:2003)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesNewSubfileType(tifd, 0L)) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (bps == null) {
            return false;
        }
        if (bps[0] != 8) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, new int[]{1, 7, 8})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, 5)) {
            return false;
        }
        if (!this.satisfiesOrientation(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, 4)) {
            return false;
        }
        if (!this.satisfiesPlanarConfiguration(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3})) {
            return false;
        }
        int inkSet = tifd.getInkSet();
        if (inkSet != 1) {
            return false;
        }
        int numInks = tifd.getNumberOfInks();
        if (numInks != 4) {
            return false;
        }
        if (!this.satisfiesDotRange(tifd, 0, 255)) {
            return false;
        }
        return tifd.getDocumentName() == null && niso.getScannerModelName() == null && tifd.getPageName() == null && niso.getHostComputer() == null && tifd.getSite() == null && tifd.getColorSequence() == null && tifd.getIT8Header() == null;
    }
}

