/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.csv;

import ch.docuteam.mapping.csv.CsvImportError;
import ch.docuteam.mapping.csv.CsvImportException;
import ch.docuteam.mapping.csv.CsvImportWarning;
import java.util.List;

public class ImportResult {
    private final boolean success;
    private final List<CsvImportWarning> warnings;
    private final CsvImportError error;
    private final Object[] additionalErrorObjects;

    public ImportResult(boolean success, List<CsvImportWarning> warnings, CsvImportError error, Object ... additionalErrorObjects) {
        this.success = success;
        this.warnings = warnings;
        this.error = error;
        this.additionalErrorObjects = additionalErrorObjects;
    }

    static ImportResult fromCSVImportException(CsvImportException importException) {
        return new ImportResult(false, List.of(), importException.getError(), importException.getAdditionalObjects());
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<CsvImportWarning> getWarnings() {
        return this.warnings;
    }

    public CsvImportError getError() {
        return this.error;
    }

    public Object[] getAdditionalErrorObjects() {
        return this.additionalErrorObjects;
    }

    public String getUntranslatedErrorMessage() {
        return this.error.getFormattedMessage(this.additionalErrorObjects);
    }
}

