/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.darc.exceptions.ZIPDoesNotContainMETSFileException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.gui.SmallPeskyMessageWindow;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.Pattern;
import ch.docuteam.tools.translations.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SearchView
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String ScreenTitle = I18N.translate((String)"TitleSearchInWorkspace");
    private static Dimension StartScreenSize = new Dimension(600, 400);
    private static SearchView SearchView = null;
    private final LauncherView launcherView;
    private final JTable searchResultTable;
    private final JLabel rowCountLabel;
    private final JTextField fileNameTextField;
    private final JTextField metadataTextField;
    private final JTextField fileContentTextField;
    private final JRadioButton searchModeANDRadioButton;
    private final JRadioButton searchModeORRadioButton;
    private final ButtonGroup searchModeButtonGroup;
    private final Action clearAction;
    private final Action searchAction;
    private final Action pickAction;

    private SearchView(LauncherView launcherView) {
        super(ScreenTitle);
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.launcherView = launcherView;
        this.searchResultTable = new JTable(new SearchTableModel());
        this.searchResultTable.setAutoCreateRowSorter(true);
        this.searchResultTable.setSelectionMode(0);
        this.searchResultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SearchView.this.tableSelectionChanged();
                }
            }
        });
        this.searchResultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SearchView.this.pickButtonClicked();
                }
            }
        });
        this.searchResultTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.searchResultTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.rowCountLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.fileNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchView.this.searchButtonClicked();
            }
        });
        this.fileNameTextField.setToolTipText(I18N.translate((String)"ToolTipSearchInWorkspaceFileNameTextField"));
        this.metadataTextField = new JTextField();
        this.metadataTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchView.this.searchButtonClicked();
            }
        });
        this.metadataTextField.setToolTipText(I18N.translate((String)"ToolTipSearchInWorkspaceMetadataTextField"));
        this.fileContentTextField = new JTextField();
        this.fileContentTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchView.this.searchButtonClicked();
            }
        });
        this.fileContentTextField.setToolTipText(I18N.translate((String)"ToolTipSearchInWorkspaceFileContentTextField"));
        this.fileContentTextField.setEnabled(false);
        this.searchModeANDRadioButton = new JRadioButton(I18N.translate((String)"LabelSearchModeAND"));
        this.searchModeANDRadioButton.setSelected(true);
        this.searchModeANDRadioButton.setToolTipText(I18N.translate((String)"ToolTipSearchModeAND"));
        this.searchModeORRadioButton = new JRadioButton(I18N.translate((String)"LabelSearchModeOR"));
        this.searchModeORRadioButton.setToolTipText(I18N.translate((String)"ToolTipSearchModeOR"));
        this.searchModeButtonGroup = new ButtonGroup();
        this.searchModeButtonGroup.add(this.searchModeANDRadioButton);
        this.searchModeButtonGroup.add(this.searchModeORRadioButton);
        this.searchAction = new AbstractAction(I18N.translate((String)"ActionSearchInWorkspace"), PackerConstants.getImageIcon("Search.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchView.this.searchButtonClicked();
            }
        };
        this.searchAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSearchInWorkspace"));
        this.clearAction = new AbstractAction(I18N.translate((String)"ActionSearchInWorkspaceClearTextField"), PackerConstants.getImageIcon("Clear.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchView.this.clearButtonClicked();
            }
        };
        this.clearAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSearchInWorkspaceClearTextField"));
        this.pickAction = new AbstractAction(I18N.translate((String)"ActionSearchInWorkspacePick"), PackerConstants.getImageIcon("Open.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchView.this.pickButtonClicked();
            }
        };
        this.pickAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSearchInWorkspacePick"));
        JButton searchButton = new JButton(this.searchAction);
        searchButton.setHideActionText(true);
        JButton clearButton = new JButton(this.clearAction);
        clearButton.setHideActionText(true);
        JButton pickButton = new JButton(this.pickAction);
        pickButton.setHideActionText(true);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.searchModeANDRadioButton);
        buttonPanel.add(this.searchModeORRadioButton);
        buttonPanel.add(searchButton);
        buttonPanel.add(clearButton);
        GridBagPanel mainPanel = new GridBagPanel(new Insets(0, 5, 0, 5));
        mainPanel.add((Component)new JLabel(I18N.translate((String)"LabelSearchMetadata")), 3, 1, 13);
        mainPanel.add((Component)this.metadataTextField, 3, 2, 17, 2, 1.0, 0.0);
        mainPanel.add((Component)new JLabel(I18N.translate((String)"LabelSearchSIPName")), 3, 3, 13);
        mainPanel.add((Component)this.fileNameTextField, 3, 4, 17, 2, 1.0, 0.0);
        mainPanel.add((Component)buttonPanel, 7, 7, 1, 4, 17);
        mainPanel.add((Component)new JScrollPane(this.searchResultTable), 8, 8, 1, 4, 10, 1, 1.0, 1.0);
        mainPanel.add((Component)this.rowCountLabel, 9, 9, 1, 3, 17);
        mainPanel.add((Component)pickButton, 9, 4, 13);
        this.add((Component)mainPanel, "Center");
        this.setPreferredSize(StartScreenSize);
        this.pack();
        this.setLocation(launcherView.getLocation().x + 50, launcherView.getLocation().y + 50);
        this.enableOrDisableActions();
    }

    public static void open(LauncherView launcherView) {
        if (SearchView == null) {
            SearchView = new SearchView(launcherView);
        }
        ch.docuteam.packer.gui.launcher.SearchView.SearchView.metadataTextField.requestFocusInWindow();
        SearchView.setVisible(true);
    }

    public static void closeAndDispose() {
        if (SearchView != null) {
            SearchView.setVisible(false);
            SearchView.dispose();
        }
    }

    private void tableSelectionChanged() {
        this.enableOrDisableActions();
    }

    private void searchButtonClicked() {
        new SwingWorker<Integer, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInBackground() {
                SearchView.this.setCursor(Cursor.getPredefinedCursor(3));
                SmallPeskyMessageWindow waitWindow = SmallPeskyMessageWindow.openBlocking((Window)SearchView.this, (String)"...");
                try {
                    String fileNamePattern = SearchView.this.fileNameTextField.getText();
                    String searchString = SearchView.this.metadataTextField.getText();
                    if (searchString.isEmpty()) {
                        Integer n = 0;
                        return n;
                    }
                    if (fileNamePattern.isEmpty()) {
                        fileNamePattern = "*";
                    }
                    final Pattern filePattern = new Pattern(new String[]{fileNamePattern});
                    String[] matchingSIPNames = new File(SearchView.this.launcherView.getSipDirectory().toString()).list(new FilenameFilter(){

                        @Override
                        public boolean accept(File workspaceFolder, String fileName) {
                            return !fileName.startsWith(".") && !fileName.endsWith(".lock") && filePattern.match(fileName);
                        }
                    });
                    Document doc = null;
                    ArrayList<SearchResultElement> searchResult = new ArrayList<SearchResultElement>(matchingSIPNames.length);
                    for (String matchingSIPName : matchingSIPNames) {
                        Logger.debug((Object)("Searching in packet: " + matchingSIPName));
                        waitWindow.setText(matchingSIPName);
                        String sipName = SearchView.this.launcherView.getSipDirectory() + File.separator + matchingSIPName;
                        if (new File(sipName).isDirectory() && !new File(sipName + File.separator + "mets.xml").exists()) continue;
                        try {
                            List<NodeAbstract> nodes;
                            doc = Document.openReadOnly(sipName, "docuteam packer");
                            List<NodeAbstract> list = nodes = SearchView.this.searchModeANDRadioButton.isSelected() ? doc.searchForAllQuoted(searchString) : doc.searchForAnyQuoted(searchString);
                            if (nodes.isEmpty()) continue;
                            for (NodeAbstract node : nodes) {
                                searchResult.add(new SearchResultElement(matchingSIPName, node));
                            }
                        }
                        catch (ZIPDoesNotContainMETSFileException nodes) {
                        }
                        catch (Exception ex) {
                            Logger.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                        finally {
                            if (doc != null) {
                                try {
                                    doc.cleanupWorkingCopy();
                                }
                                catch (FileUtilExceptionListException fileUtilExceptionListException) {}
                            }
                        }
                    }
                    ((SearchTableModel)SearchView.this.searchResultTable.getModel()).setList(searchResult);
                }
                finally {
                    waitWindow.close();
                    SearchView.this.setCursor(Cursor.getPredefinedCursor(0));
                    SearchView.this.toFront();
                }
                int searchResultCount = ((SearchTableModel)SearchView.this.searchResultTable.getModel()).getRowCount();
                if (searchResultCount == 0) {
                    SearchView.this.rowCountLabel.setForeground(Color.RED);
                    SearchView.this.rowCountLabel.setText(I18N.translate((String)"MessageSearchNothingFound"));
                } else {
                    SearchView.this.rowCountLabel.setForeground(Color.BLACK);
                    SearchView.this.rowCountLabel.setText("" + ((SearchTableModel)SearchView.this.searchResultTable.getModel()).getRowCount());
                }
                SearchView.this.enableOrDisableActions();
                return 0;
            }
        }.execute();
    }

    private void clearButtonClicked() {
        this.fileNameTextField.setText("");
        this.metadataTextField.setText("");
        this.fileContentTextField.setText("");
        ((SearchTableModel)this.searchResultTable.getModel()).clearList();
        this.rowCountLabel.setText("");
        this.enableOrDisableActions();
    }

    private void pickButtonClicked() {
        int selectionIndex = this.searchResultTable.getSelectedRow();
        if (selectionIndex == -1) {
            return;
        }
        int translatedIndexAfterSorting = this.searchResultTable.convertRowIndexToModel(selectionIndex);
        SearchResultElement pickedElement = ((SearchTableModel)this.searchResultTable.getModel()).get(translatedIndexAfterSorting);
        this.launcherView.openSIPInWorkspace(pickedElement.sipName, Document.Mode.ReadWrite, pickedElement.node.getAdmId());
    }

    private void enableOrDisableActions() {
        this.pickAction.setEnabled(this.searchResultTable.getSelectedRow() != -1);
    }

    private class SearchResultElement {
        private final String sipName;
        private final NodeAbstract node;

        public SearchResultElement(String sipName, NodeAbstract node) {
            this.sipName = sipName;
            this.node = node;
        }
    }

    public class SearchTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<SearchResultElement> searchResult = new ArrayList<SearchResultElement>();

        public void setList(List<SearchResultElement> searchResult) {
            this.searchResult = searchResult;
            this.fireTableDataChanged();
        }

        public void clearList() {
            this.searchResult.clear();
            this.fireTableDataChanged();
        }

        public SearchResultElement get(int rowIndex) {
            return this.searchResult.get(rowIndex);
        }

        @Override
        public int getRowCount() {
            return this.searchResult.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return I18N.translate((String)"HeaderSearchInWorkspaceResultSIP");
                }
                case 1: {
                    return I18N.translate((String)"HeaderSearchInWorkspaceResultFile");
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SearchResultElement resultElement = this.searchResult.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return resultElement.sipName;
                }
                case 1: {
                    return ((NodeAbstract)resultElement.node.getTreePath().getLastPathComponent()).getPathString();
                }
            }
            return null;
        }
    }
}

