/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class MarkerChunk
extends Chunk {
    public MarkerChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        int numMarkers = module.readUnsignedShort(this._dstream);
        if (numMarkers == 0) {
            return true;
        }
        ArrayList<Property> markerList = new ArrayList<Property>(numMarkers);
        for (int i = 0; i < numMarkers; ++i) {
            int id = module.readUnsignedShort(this._dstream);
            long position = module.readUnsignedInt(this._dstream);
            String markerName = module.readPascalString(this._dstream);
            Property[] mArr = new Property[]{new Property("ID", PropertyType.INTEGER, (Object)new Integer(id)), new Property("Position", PropertyType.LONG, (Object)new Long(position)), new Property("Name", PropertyType.STRING, (Object)markerName)};
            markerList.add(new Property("Marker", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)mArr));
        }
        module.addAiffProperty(new Property("Markers", PropertyType.PROPERTY, PropertyArity.LIST, markerList));
        return true;
    }
}

