/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ContCodestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentInputStream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentListBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

public class FragmentTableBox
extends JP2Box {
    public FragmentTableBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        boolean retval = true;
        this.initBytesRead();
        this.hasBoxes = true;
        JP2Box box = (JP2Box)this.next();
        if (box == null) {
            return false;
        }
        if (box instanceof FragmentListBox) {
            FragmentListBox fbox = (FragmentListBox)box;
            if (!fbox.readBox()) {
                return false;
            }
            List fragList = fbox.getFragmentList();
            if (fragList != null) {
                JhoveBase base = this._module.getBase();
                int bufSize = base.getBufferSize();
                FragmentInputStream fragStream = new FragmentInputStream(fragList, this._raf, bufSize);
                DataInputStream dfstrm = new DataInputStream(fragStream);
                int ncs = this._module.getNCodestreams() + 1;
                this._module.setNCodestreams(ncs);
                Codestream curCodestream = this._module.getCodestream(ncs);
                long len = this._boxHeader.getLength() == 0L ? 0L : this._boxHeader.getDataLength();
                ContCodestream ccs = new ContCodestream(this._module, dfstrm, len);
                retval = ccs.readCodestream(curCodestream, this._repInfo);
            }
        } else {
            this._repInfo.setMessage((Message)new ErrorMessage("Invalid fragment table", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        this.finalizeBytesRead();
        return retval;
    }

    @Override
    protected String getSelfPropName() {
        return "Fragment Table Box";
    }
}

