/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.Jpeg2000Module;
import edu.harvard.hul.ois.jhove.module.jpeg2000.AssociationBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BPCCBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CaptureResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ChannelDefBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamRegBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorGroupBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorSpecBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CompOptionsBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComponentMapBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComposLayerHdrBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CompositionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ContCodestreamBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DDResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DataEntryURLBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DefaultBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DesiredReproBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DigSignatureBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentListBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentTableBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.GTSOBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.IPRBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ImageHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.InstructionSetBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.LabelBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.NumberListBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.OpacityBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PaletteBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ROIBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ReaderRequirementsBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDInfoBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDListBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.XMLBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class JP2Box
extends BoxHolder {
    protected long startBytesRead;
    protected long _bytesRead;
    protected List<Property> associations;
    protected static final String noJP2Hdr = "Other boxes may not occur before JP2 Header";
    protected static final String DESCRIPTION_NAME = "Description";

    public JP2Box(RandomAccessFile raf) {
        super(raf);
        this.init(null);
    }

    public JP2Box(RandomAccessFile raf, BoxHolder parent) {
        super(raf);
        this.init(parent);
    }

    protected void init(BoxHolder parent) {
        this._parentBox = parent instanceof JP2Box ? (JP2Box)parent : null;
        this._bytesRead = 0L;
        this.associations = new LinkedList<Property>();
    }

    public void setModule(Jpeg2000Module module) {
        this._module = module;
    }

    public void setBoxHeader(BoxHeader hdr) {
        this._boxHeader = hdr;
        this.bytesLeft = this._boxHeader.getDataLength();
    }

    public void setRepInfo(RepInfo info) {
        this._repInfo = info;
    }

    public void setDataInputStream(DataInputStream dstrm) {
        this._dstrm = dstrm;
    }

    public void setRandomAccessFile(RandomAccessFile raf) {
        this._raf = raf;
    }

    public static JP2Box boxMaker(String hType, BoxHolder parent) {
        JP2Box box = null;
        RandomAccessFile raf = null;
        if (parent != null) {
            raf = parent._raf;
        }
        box = "jp2h".equals(hType) ? new JP2HeaderBox(raf, parent) : ("asoc".equals(hType) ? new AssociationBox(raf, parent) : ("bpcc".equals(hType) ? new BPCCBox(raf, parent) : ("chck".equals(hType) ? new DigSignatureBox(raf, parent) : ("cdef".equals(hType) ? new ChannelDefBox(raf, parent) : ("cgrp".equals(hType) ? new ColorGroupBox(raf, parent) : ("cmap".equals(hType) ? new ComponentMapBox(raf, parent) : ("colr".equals(hType) ? new ColorSpecBox(raf, parent) : ("comp".equals(hType) ? new CompositionBox(raf, parent) : ("copt".equals(hType) ? new CompOptionsBox(raf, parent) : ("creg".equals(hType) ? new CodestreamRegBox(raf, parent) : ("drep".equals(hType) ? new DesiredReproBox(raf, parent) : ("flst".equals(hType) ? new FragmentListBox(raf, parent) : ("ftbl".equals(hType) ? new FragmentTableBox(raf, parent) : ("gtso".equals(hType) ? new GTSOBox(raf, parent) : ("inst".equals(hType) ? new InstructionSetBox(raf, parent) : ("ihdr".equals(hType) ? new ImageHeaderBox(raf, parent) : ("jp2c".equals(hType) ? new ContCodestreamBox(raf, parent) : ("jpch".equals(hType) ? new CodestreamHeaderBox(raf, parent) : ("jplh".equals(hType) ? new ComposLayerHdrBox(raf, parent) : ("jp2i".equals(hType) ? new IPRBox(raf, parent) : ("lbl ".equals(hType) ? new LabelBox(raf, parent) : ("nlst".equals(hType) ? new NumberListBox(raf, parent) : ("opct".equals(hType) ? new OpacityBox(raf, parent) : ("pclr".equals(hType) ? new PaletteBox(raf, parent) : ("res ".equals(hType) ? new ResolutionBox(raf, parent) : ("roid".equals(hType) ? new ROIBox(raf, parent) : ("resc".equals(hType) ? new CaptureResolutionBox(raf, parent) : ("resd".equals(hType) ? new DDResolutionBox(raf, parent) : ("rreq".equals(hType) ? new ReaderRequirementsBox(raf, parent) : ("uinf".equals(hType) ? new UUIDInfoBox(raf, parent) : ("ulst".equals(hType) ? new UUIDListBox(raf, parent) : ("url ".equals(hType) ? new DataEntryURLBox(raf, parent) : ("uuid".equals(hType) ? new UUIDBox(raf, parent) : ("xml ".equals(hType) ? new XMLBox(raf, parent) : new DefaultBox(raf)))))))))))))))))))))))))))))))))));
        return box;
    }

    protected void initBytesRead() {
        this.startBytesRead = this._module.getFilePos();
    }

    protected void finalizeBytesRead() {
        this._bytesRead = this._module.getFilePos() - this.startBytesRead;
    }

    public abstract boolean readBox() throws IOException;

    public int getBytesRead() {
        return (int)this._bytesRead;
    }

    public void skipBox() throws IOException {
        this.initBytesRead();
        if (this._boxHeader.getLength() != 0L) {
            this._module.skipBytes(this._dstrm, (int)this._boxHeader.getDataLength(), this._module);
        }
        this.finalizeBytesRead();
    }

    protected void addAssociation(Property p) {
        this.associations.add(p);
    }

    protected void wrongBoxSize() {
        this._repInfo.setMessage((Message)new ErrorMessage("Incorrect Box size for " + this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected void wrongBoxContext() {
        this._repInfo.setMessage((Message)new ErrorMessage("Invalid context for " + this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected void emptyBox() {
        this._repInfo.setMessage((Message)new ErrorMessage("Box is empty", "Box type = " + this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected Property makeAssocProperty() {
        if (this.associations.isEmpty()) {
            return null;
        }
        return new Property("Associations", PropertyType.PROPERTY, PropertyArity.LIST, this.associations);
    }

    protected Property selfDescProperty() {
        ArrayList<Property> subprops = new ArrayList<Property>(2);
        String name = this.getSelfPropName();
        if (name == null) {
            return null;
        }
        subprops.add(new Property("Name", PropertyType.STRING, (Object)name));
        Property p2 = this.getSelfPropDesc();
        if (p2 != null) {
            subprops.add(p2);
        }
        return new Property("Box", PropertyType.PROPERTY, PropertyArity.LIST, subprops);
    }

    @Override
    protected String getSelfPropName() {
        return null;
    }

    protected Property getSelfPropDesc() {
        return null;
    }

    protected long getLength() {
        return this._boxHeader.getLength();
    }
}

