/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.Comment;
import edu.harvard.hul.ois.jhove.module.pdf.Parser;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.io.IOException;

public final class PdfHeader {
    public static final String PDF_VER1_HEADER_PREFIX = "PDF-1.";
    public static final String PDF_SIG_HEADER = "%PDF-1.";
    public static final String POSTSCRIPT_HEADER_PREFIX = "!PS-Adobe-";
    public static final int MAX_VALID_MAJOR_VERSION = 7;
    private final String versionString;
    private final boolean isPdfACompilant;

    private PdfHeader(String versionString, boolean isPdfaCompliant) {
        this.versionString = versionString;
        this.isPdfACompilant = isPdfaCompliant;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public boolean isPdfACompliant() {
        return this.isPdfACompilant;
    }

    public boolean isVersionValid() {
        int minorVersion = 8;
        try {
            minorVersion = PdfHeader.getMinorVersion(this.versionString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return minorVersion <= 7;
    }

    static PdfHeader fromValues(String versionString, boolean isPdfaCompliant) {
        if (versionString == null) {
            throw new NullPointerException("Parameter versionString can not be null.");
        }
        return new PdfHeader(versionString, isPdfaCompliant);
    }

    public static PdfHeader parseHeader(Parser parser) {
        String version;
        boolean isPdfACompliant;
        block10: {
            int n;
            Token token = null;
            String value = null;
            isPdfACompliant = false;
            version = null;
            while (true) {
                if (parser.getOffset() > 1024L) {
                    return null;
                }
                try {
                    token = null;
                    token = parser.getNext(1024L);
                }
                catch (IOException ee) {
                    return null;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                if (token == null) {
                    return null;
                }
                if (!(token instanceof Comment)) continue;
                value = ((Comment)token).getValue();
                if (value.indexOf(PDF_VER1_HEADER_PREFIX) == 0) {
                    version = value.substring(4, 7);
                    isPdfACompliant = true;
                    break block10;
                }
                if (value.indexOf(POSTSCRIPT_HEADER_PREFIX) == 0 && (n = value.indexOf(PDF_VER1_HEADER_PREFIX)) >= 11) break;
            }
            version = value.substring(n + 4);
        }
        if (version == null) {
            return null;
        }
        try {
            isPdfACompliant = PdfHeader.isTokenPdfACompliant(parser.getNext());
        }
        catch (Exception excep) {
            isPdfACompliant = false;
        }
        return new PdfHeader(version, isPdfACompliant);
    }

    private static int getMinorVersion(String version) {
        double doubleVer = Double.parseDouble(version);
        double fractPart = doubleVer % 1.0;
        int minor = (int)(10.0 * fractPart);
        return minor;
    }

    private static boolean isTokenPdfACompliant(Token token) {
        String cmt = ((Comment)token).getValue();
        char[] cmtArray = cmt.toCharArray();
        int ctlcnt = 0;
        for (int i = 0; i < 4; ++i) {
            if (cmtArray[i] <= '\u007f') continue;
            ++ctlcnt;
        }
        return ctlcnt > 3;
    }
}

