/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfilePhotoshop
extends TiffProfile {
    public TiffProfilePhotoshop() {
        this._profileText = "Adobe Photoshop 'Advanced TIFF'";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int pi = niso.getCompressionScheme();
        if (pi == 6 || pi == 8) {
            return true;
        }
        return tifd.getImageSourceData() != null;
    }
}

