/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.dawg;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModelFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetSchema;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class DAWGTestBooleanParser
extends AbstractRDFHandler {
    private Model graph = new TreeModelFactory().createEmptyModel();
    private boolean value;

    public boolean getValue() {
        return this.value;
    }

    public void startRDF() throws RDFHandlerException {
        this.graph.clear();
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.graph.add((Object)st);
    }

    public void endRDF() throws RDFHandlerException {
        Resource resultSetNode = (Resource)Models.subject((Model)this.graph.filter(null, RDF.TYPE, (Value)DAWGTestResultSetSchema.RESULTSET, new Resource[0])).orElseThrow(() -> new RDFHandlerException("missing instance of type ResultSet"));
        Literal booleanLit = (Literal)Models.getPropertyLiteral((Model)this.graph, (Resource)resultSetNode, (IRI)DAWGTestResultSetSchema.BOOLEAN, (Resource[])new Resource[0]).orElseThrow(() -> new RDFHandlerException("missing boolean value for " + DAWGTestResultSetSchema.BOOLEAN));
        if (booleanLit.equals((Object)DAWGTestResultSetSchema.TRUE)) {
            this.value = true;
        } else if (booleanLit.equals((Object)DAWGTestResultSetSchema.FALSE)) {
            this.value = false;
        } else {
            throw new RDFHandlerException("Invalid boolean value: " + booleanLit);
        }
    }
}

