/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.startup;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.InputStream;
import java.util.Properties;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class TaskScheduler {
    private static ExLogger log = ExLogger.getExLogger(TaskScheduler.class);
    private static TaskScheduler taskSchedulerInstance = null;
    private Scheduler clusteredScheduler;

    public static synchronized TaskScheduler getInstance() {
        if (taskSchedulerInstance == null) {
            taskSchedulerInstance = new TaskScheduler();
            taskSchedulerInstance.getClusterScheduler();
        }
        return taskSchedulerInstance;
    }

    public Scheduler getClusterScheduler() {
        if (this.clusteredScheduler == null) {
            try {
                Properties props = new Properties();
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("quartz.properties");
                props.load(inputStream);
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(props);
                this.clusteredScheduler = schedulerFactory.getScheduler();
                this.clusteredScheduler.start();
            }
            catch (Exception e) {
                TaskScheduler.logFatalError("failed to initiate cluster scheduler", e);
            }
        }
        return this.clusteredScheduler;
    }

    public void startClusterScheduler() {
        try {
            if (!this.getClusterScheduler().isStarted()) {
                this.getClusterScheduler().start();
            }
        }
        catch (Exception e) {
            TaskScheduler.logFatalError("failed to start cluster scheduler", e);
        }
    }

    public void addClusteredTask(JobDetail detail, Trigger trigger) {
        log.info("adding: (" + detail.getName() + "," + trigger.getName() + ")");
        if (this.getClusterScheduler() == null) {
            TaskScheduler.logFatalError("failed to add task ,infra task scheduler initialazation failed", null);
        } else {
            try {
                JobDetail existingDetail = this.clusteredScheduler.getJobDetail(detail.getName(), detail.getGroup());
                if (existingDetail == null) {
                    detail.setDurability(true);
                    this.clusteredScheduler.addJob(detail, false);
                }
                trigger.setJobName(detail.getName());
                this.clusteredScheduler.scheduleJob(trigger);
            }
            catch (SchedulerException e) {
                TaskScheduler.logFatalError("failed to schedule task", e);
            }
        }
    }

    public void pauseClusteredScheduler() {
        try {
            this.clusteredScheduler.pauseAll();
        }
        catch (SchedulerException e) {
            log.error("failed to pause scheduler", (Exception)((Object)e), new String[0]);
        }
    }

    public void resumeClusteredScheduler() {
        try {
            this.clusteredScheduler.resumeAll();
        }
        catch (SchedulerException e) {
            TaskScheduler.logFatalError("failed to resume scheduler", e);
        }
    }

    public JobDetail getJobDetail(String jobName) {
        JobDetail jobDetail = null;
        try {
            jobDetail = this.clusteredScheduler.getJobDetail(jobName, "DEFAULT");
        }
        catch (SchedulerException e) {
            log.error("failed to retrieve job details for job " + jobName, new String[0]);
        }
        return jobDetail;
    }

    public void removeClusteredTask(String name) {
        log.info("removing job: " + name);
        try {
            this.clusteredScheduler.deleteJob(name, "DEFAULT");
        }
        catch (SchedulerException e) {
            log.error("failed to unschedule job: " + name, (Exception)((Object)e), new String[0]);
        }
    }

    private static void logFatalError(String message, Throwable e) {
        if (e == null) {
            log.error("QUATZ_LOAD_ERROR: " + message, new String[0]);
        } else {
            log.error("QUATZ_LOAD_ERROR: " + message, e, new String[0]);
        }
    }
}

