/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.config;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.interfaces.Resettable;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PrivilegeCacheManager
implements Resettable {
    private static final ExLogger log = ExLogger.getExLogger(PrivilegeCacheManager.class);
    private static PrivilegeCacheManager cmt = null;
    private final HashMap<String, ArrayList<String>> privilegesForRoles = new HashMap();
    private boolean isInit = false;

    public static synchronized PrivilegeCacheManager getInstance() {
        if (cmt == null) {
            cmt = new PrivilegeCacheManager();
            cmt.load();
        }
        return cmt;
    }

    private void load() {
        try {
            this.retrievePrivilegesForRoles();
            this.isInit = true;
            log.info("Setting Loaded");
        }
        catch (Throwable e) {
            log.error("Failed to load", new String[0]);
        }
    }

    private void retrievePrivilegesForRoles() {
        log.info("Setting Privileges For Roles");
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("RolePrivileges");
        for (HMappingTables row : mappingTables) {
            ArrayList<Object> parameters;
            String role = row.getTargetCode();
            if (this.privilegesForRoles.get(role) == null) {
                parameters = new ArrayList<String>();
                parameters.add(row.getSourceCode1());
                this.privilegesForRoles.put(role, parameters);
                continue;
            }
            parameters = this.privilegesForRoles.get(role);
            parameters.add(row.getSourceCode1());
        }
    }

    public HashMap<String, ArrayList<String>> getPrivilegesForRoles() {
        return this.privilegesForRoles;
    }

    public ArrayList<String> getPrivileges2Role(String roleName) {
        ArrayList<String> list = this.privilegesForRoles.get(roleName);
        if (list == null) {
            list = new ArrayList();
            this.privilegesForRoles.put(roleName, list);
        }
        return list;
    }

    @Override
    public synchronized void reset() {
        this.load();
    }

    public static void main(String[] args) {
        new PrivilegeCacheManager().load();
    }
}

