/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.config;

import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.digitool.config.ConfigurationManager;
import com.exlibris.digitool.repository.conf.xmlbeans.Metadata;
import com.exlibris.digitool.repository.conf.xmlbeans.RpConfigurationDocument;
import java.io.File;
import java.io.IOException;

public class RepositoryConfigurationMDHandler {
    private static final String RP_CONF_FILE = "repository_configuration.xml";
    private static final String RP_CONF_FILE_TMPL = "repository_configuration.xml.tmpl";

    public static void main(String[] args) {
        if (args.length < 3 || args.length > 4) {
            RepositoryConfigurationMDHandler.usage();
            return;
        }
        String function = args[0];
        String mdName = args[1];
        String mdType = args[2];
        int id = 0;
        if (args.length == 4) {
            id = Integer.parseInt(args[3]);
        }
        if (function.equals("check")) {
            RepositoryConfigurationMDHandler.checkMD(mdName, mdType);
        } else if (function.equals("add")) {
            RepositoryConfigurationMDHandler.addMD(mdName, mdType, id);
        } else if (function.equals("check-add")) {
            RepositoryConfigurationMDHandler.checkAddMD(mdName, mdType);
        } else {
            RepositoryConfigurationMDHandler.usage();
            return;
        }
    }

    private static int checkMD(String mdName, String mdType) {
        int id = 0;
        Metadata md = ConfigurationManager.getInstance().getMetadataByNameAndType(mdName, mdType);
        if (md == null) {
            System.out.println("FOUND=FALSE");
            id = ConfigurationManager.getInstance().getLastMetadataID();
            System.out.println("LASTID=" + id);
        } else {
            System.out.println("FOUND=TRUE");
        }
        return id;
    }

    private static void addMD(String mdName, String mdType, int id) {
        String path = FSUtil.getSystemDir() + "/conf/" + RP_CONF_FILE;
        RepositoryConfigurationMDHandler.addToFile(path, mdName, mdType, id);
        path = FSUtil.getDigitoolHome() + "/profile/overwrites/conf/" + RP_CONF_FILE_TMPL;
        RepositoryConfigurationMDHandler.addToFile(path, mdName, mdType, id);
    }

    private static void checkAddMD(String mdName, String mdType) {
        int id = 0;
        id = RepositoryConfigurationMDHandler.checkMD(mdName, mdType);
        if (id != 0) {
            RepositoryConfigurationMDHandler.addMD(mdName, mdType, id + 1);
        }
    }

    private static void addToFile(String path, String mdName, String mdType, int id) {
        RpConfigurationDocument rpcd = null;
        File file = new File(path);
        try {
            rpcd = RpConfigurationDocument.Factory.parse(file);
        }
        catch (Exception e) {
            System.out.println("ERROR: failed to parse file" + path);
            return;
        }
        Metadata md = rpcd.getRpConfiguration().getMetadatas().addNewMetadata();
        md.setName(mdName);
        md.setType(mdType);
        md.setId(id);
        md.setAllowMultiple(true);
        md.setValidationSchema("");
        try {
            rpcd.save(file);
        }
        catch (IOException e) {
            System.out.println("ERROR: failed to write to file" + path + " md: " + mdName + "-" + mdType);
            return;
        }
    }

    private static void usage() {
        System.out.println("Usage: RepositoryConfigurationMDHandler <function:check|add|check-add> <md name> <md type> [<id>]");
    }
}

