/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.strings;

import java.util.ArrayList;

public class KmpStringFinder {
    private void preKmp(String pattern, ArrayList kmpNext) {
        int m = pattern.length();
        int i = 0;
        int j = -1;
        kmpNext.add(0, new Integer(-1));
        while (i < m - 1) {
            while (j > -1 && pattern.charAt(i) != pattern.charAt(j)) {
                j = (Integer)kmpNext.get(j);
            }
            if (pattern.charAt(++i) == pattern.charAt(++j)) {
                kmpNext.add(i, kmpNext.get(j));
                continue;
            }
            kmpNext.add(i, new Integer(j));
        }
    }

    public synchronized ArrayList KMP(String pattern, String text) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        ArrayList kmpNext = new ArrayList();
        this.preKmp(pattern, kmpNext);
        int i = 0;
        int n = text.length();
        int m = pattern.length();
        for (int j = 0; j < n; ++j) {
            while (i > -1 && pattern.charAt(i) != text.charAt(j)) {
                i = (Integer)kmpNext.get(i);
            }
            if (++i < m) continue;
            res.add(new Integer(j - i));
            i = (Integer)kmpNext.get(i - 1);
        }
        return res;
    }
}

