/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.ARValidator;

import com.exlibris.core.infra.common.validation.ValidationResult;
import com.exlibris.digitool.repository.api.xmlbeans.ArExpression;
import com.exlibris.digitool.repository.api.xmlbeans.ArKey;
import com.exlibris.digitool.repository.api.xmlbeans.ArOperation;
import com.exlibris.dps.ARValidator.ARValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbsARValidator
implements ARValidator {
    public static Map<String, List<String>> keyToOperation = null;
    public static Map<String, Integer> operationToLineNumbers = null;

    protected void init() {
        keyToOperation = new HashMap<String, List<String>>();
        ArrayList<String> opList = new ArrayList<String>();
        opList.add(ArOperation.WITHIN.toString());
        opList.add(ArOperation.CONTAINS.toString());
        keyToOperation.put(ArKey.IP_RANGE.toString(), opList);
        opList = new ArrayList();
        opList.add(ArOperation.EQ.toString());
        opList.add(ArOperation.BEFORE.toString());
        opList.add(ArOperation.AFTER.toString());
        keyToOperation.put(ArKey.DATE_COMPARE.toString(), opList);
        opList = new ArrayList();
        opList.add(ArOperation.EQ.toString());
        opList.add(ArOperation.NOT_EQUAL.toString());
        opList.add(ArOperation.CONTAINS.toString());
        keyToOperation.put(ArKey.GROUP.toString(), opList);
        keyToOperation.put(ArKey.BOR_DEPT_M.toString(), opList);
        keyToOperation.put(ArKey.BOR_GROUP_M.toString(), opList);
        keyToOperation.put(ArKey.BOR_TUPLES_M.toString(), opList);
        keyToOperation.put(ArKey.COURSE_ENROLLMENT_M.toString(), opList);
        keyToOperation.put(ArKey.USER_ID.toString(), opList);
        opList = new ArrayList();
        opList.add(ArOperation.EQ.toString());
        keyToOperation.put(ArKey.CONCURRENT_USERS.toString(), opList);
        keyToOperation.put(ArKey.EXPIRY_DATE.toString(), opList);
        keyToOperation.put(ArKey.ACCESS_RIGHTS_PLUGIN.toString(), opList);
        operationToLineNumbers = new HashMap<String, Integer>();
        operationToLineNumbers.put(ArOperation.WITHIN.toString(), 2);
        operationToLineNumbers.put(ArOperation.BEFORE.toString(), 2);
        operationToLineNumbers.put(ArOperation.AFTER.toString(), 2);
        operationToLineNumbers.put(ArOperation.EQ.toString(), 1);
        operationToLineNumbers.put(ArOperation.NOT_EQUAL.toString(), 1);
        operationToLineNumbers.put(ArOperation.CONTAINS.toString(), 1);
    }

    protected ValidationResult validateStructure(ArExpression expr) {
        if (keyToOperation == null && operationToLineNumbers == null) {
            this.init();
        }
        ValidationResult vr = new ValidationResult();
        Boolean isValid = false;
        String value1 = null;
        String value2 = null;
        ArKey.Enum key = expr.getKey();
        ArOperation.Enum op = expr.getArOperation();
        List<String> opList = keyToOperation.get(key.toString());
        isValid = opList.contains(op.toString());
        if (!isValid.booleanValue()) {
            vr.addMessage("Invalid operation: " + (Object)((Object)op) + " for this AR type: " + key.toString());
            vr.setValid(false);
            return vr;
        }
        int lines = operationToLineNumbers.get(op.toString());
        value1 = expr.getVal1();
        value2 = expr.getVal2();
        int count = 0;
        if (StringUtils.isNotBlank((String)value1)) {
            ++count;
            if (StringUtils.isNotBlank((String)value2)) {
                ++count;
            }
        } else {
            vr.addMessage("First value is empty.");
            vr.setValid(false);
            return vr;
        }
        if (count != lines) {
            vr.addMessage("Invalid number of lines for this operation");
            vr.setValid(false);
            return vr;
        }
        vr.setValid(true);
        return vr;
    }

    @Override
    public ValidationResult validate(ArExpression expr) {
        ValidationResult vr = this.validateStructure(expr);
        return vr;
    }
}

