/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.digitalentity;

import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.repository.persistence.HOwneredEntity;
import com.exlibris.repository.persistence.digitalentity.HDeMetadata;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="findByLockIdAndMid", query="select workingcopy from HDeWorkingCopy as workingcopy where workingcopy.mid = :mid and workingcopy.lockId = :lockId"), @NamedQuery(name="findWorkingCopyByMid", query="select workingcopy from HDeWorkingCopy as workingcopy where workingcopy.mid = :mid"), @NamedQuery(name="findByLockId", query="select workingcopy from HDeWorkingCopy as workingcopy where workingcopy.lockId = :lockId")})
public class HDeWorkingCopy
extends HOwneredEntity {
    private static final long serialVersionUID = 1L;
    public static final String TEMP_WROKING_COPY_PREFIX = "TEMP_MID_";
    private Long lockId;
    private String mid;
    private String pid;
    private String value;
    private int mdId;
    private String externalSystem;
    private String externalSystemId;

    public HDeWorkingCopy() {
    }

    public HDeWorkingCopy(HDeWorkingCopy copy) {
        this();
        this.setMid(copy.getMid());
        this.setValue(copy.getValue());
        this.setOwner(copy.getOwner());
        this.setCreator(copy.getCreator());
        this.setCreateDate(copy.getCreateDate());
    }

    public HDeWorkingCopy(HDeMetadata copy, String pid, Long lockId) {
        this();
        this.setMid(copy.getMid());
        this.setValue(copy.getValue());
        this.setOwner(copy.getOwner());
        this.setCreator(copy.getCreator());
        this.setCreateDate(copy.getCreateDate());
        this.setMdId(copy.getMdId());
        this.setExternalSystem(copy.getExternalSystem());
        this.setExternalSystemId(copy.getExternalSystemId());
        this.setPid(pid);
        this.setLockId(lockId);
    }

    @Lob
    @Column
    @Searchable
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Column(name="MID")
    @Searchable
    @Index(name="HDEWORKINGCOPY_MID")
    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    @Column(name="LOCK_ID")
    public Long getLockId() {
        return this.lockId;
    }

    public void setLockId(Long lockId) {
        this.lockId = lockId;
    }

    @Column(name="PID")
    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    @Column(name="MDID")
    public int getMdId() {
        return this.mdId;
    }

    public void setMdId(int mdId) {
        this.mdId = mdId;
    }

    @Column(name="EXTERNAL_SYSTEM")
    public String getExternalSystem() {
        return this.externalSystem;
    }

    public void setExternalSystem(String externalSystem) {
        this.externalSystem = externalSystem;
    }

    @Column(name="EXTERNAL_SYSTEM_ID")
    public String getExternalSystemId() {
        return this.externalSystemId;
    }

    public void setExternalSystemId(String externalSystemId) {
        this.externalSystemId = externalSystemId;
    }

    @Transient
    public String getTempMid() {
        return TEMP_WROKING_COPY_PREFIX + this.getId().toString();
    }

    @Transient
    public HDeMetadata getAsMetadata(boolean includeTempMid) {
        HDeMetadata md = new HDeMetadata();
        md.setApplication(this.getApplication());
        md.setCreateDate(this.getCreateDate());
        md.setCreator(this.getCreator());
        md.setModificationDate(this.getModificationDate());
        md.setModifiedBy(this.getModifiedBy());
        md.setOwner(this.getOwner());
        md.setMid(this.getMid());
        if (includeTempMid && this.getMid() == null) {
            md.setMid(this.getTempMid());
        }
        md.setValue(this.getValue());
        md.setMdId(this.getMdId());
        md.setExternalSystem(this.getExternalSystem());
        md.setExternalSystemId(this.getExternalSystemId());
        return md;
    }
}

