/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.OutputStream;
import org.jwat.arc.ArcWriter;
import org.jwat.arc.ArcWriterCompressed;
import org.jwat.arc.ArcWriterUncompressed;

public class ArcWriterFactory {
    protected ArcWriterFactory() {
    }

    public static ArcWriter getWriter(OutputStream out, boolean compressed) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        if (compressed) {
            return new ArcWriterCompressed(out);
        }
        return new ArcWriterUncompressed(out);
    }

    public static ArcWriter getWriter(OutputStream out, int buffer_size, boolean compressed) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' parameter is less than or equal to zero!");
        }
        if (compressed) {
            return new ArcWriterCompressed(out, buffer_size);
        }
        return new ArcWriterUncompressed(out, buffer_size);
    }

    public static ArcWriter getWriterUncompressed(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        return new ArcWriterUncompressed(out);
    }

    public static ArcWriter getWriterUncompressed(OutputStream out, int buffer_size) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' parameter is less than or equal to zero!");
        }
        return new ArcWriterUncompressed(out, buffer_size);
    }

    public static ArcWriter getWriterCompressed(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        return new ArcWriterCompressed(out);
    }

    public static ArcWriter getWriterCompressed(OutputStream out, int buffer_size) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' parameter is less than or equal to zero!");
        }
        return new ArcWriterCompressed(out, buffer_size);
    }
}

