/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public class Tile
extends ImageFilterPlus {
    private int width;
    private int height;
    private int newWidth;
    private int newHeight;
    private int nWide;
    private int nHigh;

    public Tile(ImageProducer imageProducer, int n, int n2) {
        super(imageProducer, true);
        this.newWidth = n;
        this.newHeight = n2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            Tile.usage();
        }
        Tile tile = new Tile(null, Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, tile));
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.consumer.setDimensions(this.newWidth, this.newHeight);
        this.nWide = (this.newWidth + n - 1) / n;
        this.nHigh = (this.newHeight + n2 - 1) / n2;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = 0;
        while (n7 < this.nHigh) {
            int n8 = n7 * this.height + n2;
            int n9 = n4;
            if (n8 + n9 > this.newHeight) {
                n9 = this.newHeight - n8;
            }
            int n10 = 0;
            while (n10 < this.nWide) {
                int n11 = n10 * this.width + n;
                int n12 = n3;
                if (n11 + n12 > this.newWidth) {
                    n12 = this.newWidth - n11;
                }
                this.consumer.setPixels(n11, n8, n12, n9, colorModel, byArray, n5, n6);
                ++n10;
            }
            ++n7;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = 0;
        while (n7 < this.nHigh) {
            int n8 = n7 * this.height + n2;
            int n9 = n4;
            if (n8 + n9 > this.newHeight) {
                n9 = this.newHeight - n8;
            }
            int n10 = 0;
            while (n10 < this.nWide) {
                int n11 = n10 * this.width + n;
                int n12 = n3;
                if (n11 + n12 > this.newWidth) {
                    n12 = this.newWidth - n11;
                }
                this.consumer.setPixels(n11, n8, n12, n9, colorModel, nArray, n5, n6);
                ++n10;
            }
            ++n7;
        }
    }

    private static void usage() {
        System.err.println("usage: Tile <width> <height>");
        System.exit(1);
    }
}

