/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.resource;

import com.exlibris.core.infra.model.resource.EREConfiguration;
import gov.loc.zing.srw.configuration.ExternalResourceExplorerDocument;
import gov.loc.zing.srw.configuration.Parm;
import gov.loc.zing.srw.configuration.Protocol;
import gov.loc.zing.srw.configuration.RepositoryName;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParseEREConfig {
    static Log log = LogFactory.getLog(ParseEREConfig.class);
    public List<String> repos = new ArrayList<String>();
    public Map<String, String> reposTypes = new Hashtable<String, String>();
    public Map<String, String> voyagerUpdateUrlMap = new Hashtable<String, String>();
    public Map<String, String> alephDetachUrlMap = new Hashtable<String, String>();
    public Map<String, List<EREConfiguration>> configData = new Hashtable<String, List<EREConfiguration>>();
    ExternalResourceExplorerDocument configDoc = null;

    public ParseEREConfig(String srwConfigFile) {
        if (srwConfigFile == null) {
            log.error((Object)"Failed to load external search engine configuration file.");
            return;
        }
        try {
            this.configDoc = ExternalResourceExplorerDocument.Factory.parse(srwConfigFile);
            if (this.configDoc != null) {
                ExternalResourceExplorerDocument.ExternalResourceExplorer rootDoc = this.configDoc.getExternalResourceExplorer();
                RepositoryName[] repoNames = rootDoc.getRepositoryNameArray();
                for (int i = 0; i < repoNames.length; ++i) {
                    RepositoryName rname = repoNames[i];
                    String type = rname.getType();
                    if (type == null) {
                        type = "VOYAGER";
                    }
                    StringBuffer name = new StringBuffer(rname.getName());
                    this.repos.add(name.toString());
                    this.reposTypes.put(name.toString(), type.toUpperCase());
                    ArrayList<EREConfiguration> configs = new ArrayList<EREConfiguration>();
                    Protocol[] protocols = rname.getProtocolArray();
                    for (int prot = 0; prot < protocols.length; ++prot) {
                        EREConfiguration conf = new EREConfiguration();
                        Protocol currentProt = protocols[prot];
                        conf.setRepo(name.toString());
                        conf.setProtocol(currentProt.getType());
                        Parm[] parms = currentProt.getParmArray();
                        for (int p = 0; p < parms.length; ++p) {
                            Parm parm = parms[p];
                            if (parm != null && parm.getName().equals("updateUrl")) {
                                this.voyagerUpdateUrlMap.put(rname.getName(), parm.getStringValue());
                                continue;
                            }
                            if (parm != null && parm.getName().equals("detachUrl")) {
                                this.alephDetachUrlMap.put(rname.getName(), parm.getStringValue());
                                continue;
                            }
                            if (parm == null) continue;
                            conf.setValues(parm.getName(), parm.getStringValue());
                        }
                        configs.add(conf);
                    }
                    this.configData.put(name.toString(), configs);
                }
            } else {
                log.error((Object)"The parsed configuration file has no entries.");
            }
        }
        catch (Exception ex) {
            log.error((Object)("Got exception in parse External Search Engine Configuration: " + ex.getMessage()));
        }
    }

    public List<EREConfiguration> getRepoValues(String repo) {
        return this.configData.get(repo);
    }

    public List<String> getRepos() {
        return this.repos;
    }

    public void setRepos(List<String> repos) {
        this.repos = repos;
    }

    public Map<String, List<EREConfiguration>> getConfigData() {
        return this.configData;
    }

    public void setConfigData(Map<String, List<EREConfiguration>> configData) {
        this.configData = configData;
    }

    public Map<String, String> getVoyagerUpdateUrlMap() {
        return this.voyagerUpdateUrlMap;
    }

    public void setVoyagerUpdateUrlMap(Map<String, String> voyagerUpdateUrlMap) {
        this.voyagerUpdateUrlMap = voyagerUpdateUrlMap;
    }

    public Map<String, String> getAlephDetachUrlMap() {
        return this.alephDetachUrlMap;
    }

    public void setAlephDetachUrlMap(Map<String, String> alephDetachUrlMap) {
        this.alephDetachUrlMap = alephDetachUrlMap;
    }

    public String getRepoType(String repo) {
        return this.reposTypes.get(repo);
    }
}

