/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.formatting;

import com.exlibris.core.sdk.strings.StringUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class Mods {
    public static final int MODS_NAMESPACE = 10;
    public static final String MODS_PREFIX = "mods";
    public static final String TYPE = "type";
    private Document m_document = null;
    private Element m_record = null;
    Namespace modsNamespace = new Namespace("mods", "http://www.loc.gov/mods/");
    Namespace xlinkNamespace = new Namespace("xlink", "http://www.w3.org/TR/xlink");
    Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    QName XsiQName = new QName("type", this.xsiNamespace);

    protected Mods() {
        this.createNew();
    }

    protected Mods(String xml) throws DocumentException {
        this.createFromXml(xml);
    }

    public Mods copyMods() throws Exception {
        return new Mods(this.toXml());
    }

    private void createFromXml(String xml) throws DocumentException {
        SAXReader reader = new SAXReader();
        this.m_document = reader.read((Reader)new StringReader(xml));
        this.m_record = this.m_document.getRootElement();
    }

    private void createNew() {
        this.m_document = DocumentFactory.getInstance().createDocument();
        this.m_record = this.m_document.addElement(MODS_PREFIX);
        this.m_record.add(this.modsNamespace);
        this.m_record.add(this.xlinkNamespace);
        this.m_record.add(this.xsiNamespace);
    }

    public void addElement(String xPathKey, String value) {
        ModsElement modsElem = this.parseKey(xPathKey);
        if (modsElem != null) {
            this.addElement(modsElem.key, value);
        }
    }

    public String getValueByPath(String xPathKey) {
        ModsElement modsElem = this.parseKey(xPathKey);
        if (modsElem == null) {
            return null;
        }
        return this.getValue(modsElem.key);
    }

    public String getValue(String key) {
        int i;
        StringBuffer xpath = new StringBuffer("//");
        if (key == null || key.length() == 0) {
            return null;
        }
        String[] keys = key.split("/");
        String index = null;
        if (StringUtils.isDigitsString(keys[keys.length - 1])) {
            index = keys[keys.length - 1];
            String[] tempKey = new String[keys.length - 1];
            for (i = 0; i < tempKey.length; ++i) {
                tempKey[i] = keys[i];
            }
            keys = tempKey;
        }
        if (!StringUtils.isEmptyString(this.getPrefix())) {
            for (int i2 = 0; i2 < keys.length; ++i2) {
                xpath.append(MODS_PREFIX).append(":").append(keys[i2]).append("/");
            }
            if (xpath.charAt(xpath.length() - 1) == '/') {
                xpath.deleteCharAt(xpath.length() - 1);
            }
        } else {
            xpath.append(this.buildPathFunc(keys));
        }
        if (index == null || index.length() == 0) {
            return this.getXPathValue(xpath.toString());
        }
        List list = this.getXPathValues(xpath.toString());
        i = Integer.parseInt(index) - 1;
        int size = list.size();
        if (size < i) {
            return (String)list.get(0);
        }
        return (String)list.get(i);
    }

    public String buildPathFunc(String[] keys) {
        StringBuffer path = new StringBuffer();
        if (!StringUtils.isEmptyString(this.getPrefix())) {
            path.append("*[name()='" + this.getPrefix() + "']");
        }
        for (int i = 0; i < keys.length; ++i) {
            path.append("/*[name()='" + keys[i] + "']");
        }
        if (path.charAt(0) == '/') {
            path.deleteCharAt(0);
        }
        return path.toString();
    }

    public List getValues(String key) {
        StringBuffer xpath = new StringBuffer("//");
        if (key == null || key.length() == 0) {
            return null;
        }
        String[] keys = key.split("/");
        if (!StringUtils.isEmptyString(this.m_document.getRootElement().getNamespace().getPrefix())) {
            for (int i = 0; i < keys.length; ++i) {
                xpath.append(MODS_PREFIX).append(":").append(keys[i]).append("/");
            }
            if (xpath.charAt(xpath.length() - 1) == '/') {
                xpath.deleteCharAt(xpath.length() - 1);
            }
        } else {
            xpath.append(this.buildPathFunc(keys));
        }
        return this.getXPathValues(xpath.toString());
    }

    public void save(String fileName) throws IOException {
        FileWriter out = new FileWriter(fileName);
        this.m_document.write((Writer)out);
        out.flush();
        out.close();
    }

    public String toXml() throws IOException {
        StringWriter sw = new StringWriter();
        this.m_document.write((Writer)sw);
        sw.flush();
        sw.close();
        return sw.getBuffer().toString();
    }

    public Document getDocument() {
        return this.m_document;
    }

    public String getPrefix() {
        return this.m_document.getRootElement().getNamespace().getPrefix();
    }

    private String getXPathValue(String xPath) {
        Node node = this.m_document.selectSingleNode(xPath);
        if (node != null) {
            return node.getText();
        }
        return null;
    }

    private List getXPathValues(String xPath) {
        List nodes = this.m_document.selectNodes(xPath);
        if (nodes != null) {
            ArrayList<String> l = new ArrayList<String>();
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                l.add(((Node)i.next()).getText());
            }
            return l;
        }
        return null;
    }

    private String getXPath(String key) {
        StringBuffer xpath = new StringBuffer("//");
        xpath.append(MODS_PREFIX);
        if (key == null || key.length() == 0) {
            return null;
        }
        xpath.append(":").append(key);
        return xpath.toString();
    }

    public void removeElemetByPath(String xPathKey) {
        ModsElement modsElem = this.parseKey(xPathKey);
        if (modsElem == null) {
            return;
        }
        this.removeElemet(modsElem.key);
    }

    public void removeElemet(String key) {
        String path = this.getXPath(key);
        this.removeNodeByXPath(path);
    }

    private void removeNodeByXPath(String xPath) {
        Node node = this.m_document.selectSingleNode(xPath);
        if (node != null) {
            node.detach();
        }
    }

    private ModsElement parseKey(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        ModsElement modsElem = new ModsElement();
        if (!key.startsWith("mods:")) {
            return null;
        }
        modsElem.namespace = 10;
        key = key.substring(5);
        int pos = key.indexOf("@");
        if (pos == -1) {
            if (key.length() > 0) {
                modsElem.key = key;
            }
        } else {
            modsElem.key = key.substring(0, pos);
        }
        return modsElem;
    }

    private class ModsElement {
        public int namespace;
        public String key;
        public String val;

        private ModsElement() {
        }

        public String toString() {
            return "namespace=" + this.namespace + ";key=" + this.key + ";val=" + this.val;
        }
    }
}

