/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.formatting;

import com.exlibris.digitool.common.pi.PIGenerator;
import gov.loc.standards.premis.ObjectDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class PremisHandler {
    public static String PREMIS_TEMPLATE = "default_premis_template.xml";
    ObjectDocument premis = null;

    public PremisHandler() {
        this.premis = ObjectDocument.Factory.newInstance();
        this.premis.addNewObject();
    }

    public PremisHandler(String premisVal) throws XmlException {
        this.premis = ObjectDocument.Factory.parse(premisVal);
    }

    public String getPIValue(String piType) {
        ObjectDocument.Object.ObjectIdentifier objId = this.getPIObject(piType);
        if (objId != null) {
            return objId.getObjectIdentifierValue();
        }
        return null;
    }

    public ObjectDocument.Object.ObjectIdentifier getPIObject(String piType) {
        ObjectDocument.Object.ObjectIdentifier[] objIds = this.premis.getObject().getObjectIdentifierArray();
        for (int i = 0; i < objIds.length; ++i) {
            ObjectDocument.Object.ObjectIdentifier identifier = objIds[i];
            if (identifier.getObjectIdentifierType() == null || !identifier.getObjectIdentifierType().trim().equalsIgnoreCase(piType)) continue;
            return identifier;
        }
        return null;
    }

    public boolean containsPIType(String piType) {
        ObjectDocument.Object.ObjectIdentifier identifier = this.getPIObject(piType);
        return identifier != null;
    }

    public boolean verifyPrefix(String piPrefix) {
        if (piPrefix == null) {
            return false;
        }
        ObjectDocument.Object.ObjectIdentifier[] objIds = this.premis.getObject().getObjectIdentifierArray();
        for (int i = 0; i < objIds.length; ++i) {
            ObjectDocument.Object.ObjectIdentifier identifier = objIds[i];
            if (identifier.getObjectIdentifierValue() == null || !identifier.getObjectIdentifierValue().trim().startsWith(piPrefix)) continue;
            return true;
        }
        return false;
    }

    public boolean verifyPrefix(String piPrefix, String piType) {
        if (piPrefix == null) {
            return false;
        }
        if (piType == null) {
            return this.verifyPrefix(piPrefix);
        }
        String pival = this.getPIValue(piType);
        if (pival != null) {
            return pival.startsWith(piPrefix);
        }
        return false;
    }

    public void setPI(PIGenerator gen) {
        ObjectDocument.Object.ObjectIdentifier objId = this.getPIObject(gen.getType());
        if (objId != null) {
            objId.setObjectIdentifierType(gen.getType());
            objId.setObjectIdentifierValue(gen.getValue());
            this.setGenerator(gen);
        }
    }

    public void addPI(PIGenerator gen) {
        ObjectDocument.Object pres = this.premis.getObject();
        if (pres == null) {
            pres = this.premis.addNewObject();
        }
        ObjectDocument.Object.ObjectIdentifier objId = pres.addNewObjectIdentifier();
        objId.setObjectIdentifierType(gen.getType());
        objId.setObjectIdentifierValue(gen.getValue());
        this.setGenerator(gen);
    }

    private void setGenerator(PIGenerator gen) {
    }

    public ObjectDocument getPremis() {
        return this.premis;
    }

    public String toString() {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        String premStr = this.premis.xmlText(options);
        premStr = premStr.replaceFirst(" xmlns:prem=", " xmlns=");
        premStr = premStr.replaceAll("<prem:", "<");
        premStr = premStr.replaceAll("</prem:", "</");
        premStr = premStr.replaceAll(" prem:", " ");
        return premStr;
    }
}

