/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.aware.j2k.codec.engine.AwJ2k;
import com.aware.j2k.codec.engine.AwJ2kException;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.digitool.common.streams.FailedToHandlerStreamException;
import com.exlibris.digitool.common.streams.StreamHandler;
import magick.ImageInfo;
import magick.MagickException;
import magick.MagickImage;

public class TiffToJp2StreamHandler
extends StreamHandler {
    private static final String AW_J2K_ERROR_UNSUPPORTED_IMAGE_TYPE = "AW_J2K_ERROR_UNSUPPORTED_IMAGE_TYPE";
    private static final ExLogger logger = ExLogger.getExLogger(TiffToJp2StreamHandler.class);

    @Override
    public void handleStream() throws FailedToHandlerStreamException {
        String fileToRead = null;
        String fileToWrite = null;
        if (this.params != null && this.params.length != 0) {
            fileToRead = this.params[0];
            fileToWrite = this.params[1];
        }
        if (fileToRead == null || fileToWrite == null) {
            throw new FailedToHandlerStreamException("one of the following is missing: 'file to read', 'file to write'");
        }
        Object jp2Converter = null;
        try {
            TiffToJp2StreamHandler.convertToJpeg2000(fileToRead, fileToWrite);
        }
        catch (AwJ2kException e) {
            if (e.getMessage().equals(AW_J2K_ERROR_UNSUPPORTED_IMAGE_TYPE)) {
                String tempJpegFileName = fileToRead + ".jpeg";
                try {
                    TiffToJp2StreamHandler.convertToJpeg(fileToRead, tempJpegFileName);
                }
                catch (MagickException mE) {
                    throw new FailedToHandlerStreamException("Fail to convert " + fileToRead + " to Jpeg2000. " + mE.getMessage());
                }
                try {
                    TiffToJp2StreamHandler.convertToJpeg2000(tempJpegFileName, fileToWrite);
                }
                catch (AwJ2kException awE) {
                    throw new FailedToHandlerStreamException("Fail to convert " + tempJpegFileName + " to Jpeg2000. " + awE.getMessage());
                }
                return;
            }
            throw new FailedToHandlerStreamException("Fail to convert Jpeg2000 to Tiff:" + e.getMessage());
        }
        catch (Exception e) {
            throw new FailedToHandlerStreamException("Fail to convert Jpeg2000 to Tiff:" + e.getMessage());
        }
    }

    private static void convertToJpeg2000(String inputFileName, String outputFileName) throws AwJ2kException {
        AwJ2k jp2Converter = null;
        try {
            jp2Converter = new AwJ2k();
            jp2Converter.AwJ2kCreate();
            jp2Converter.AwJ2kSetInputImageFile(inputFileName);
            jp2Converter.AwJ2kSetOutputType(74);
            jp2Converter.AwJ2kGetOutputImageFile(outputFileName);
        }
        finally {
            if (jp2Converter != null) {
                jp2Converter.AwJ2kDestroy();
            }
        }
    }

    private static void convertToJpeg(String inputFileName, String outputFileName) throws MagickException {
        ImageInfo info = new ImageInfo(inputFileName);
        MagickImage newImage = new MagickImage(info);
        newImage.setFileName(outputFileName);
        newImage.writeImage(info);
    }

    public static void main(String[] args) {
        TiffToJp2StreamHandler t2j = new TiffToJp2StreamHandler();
        String[] params = new String[]{"c:/temp/test2.tif", "c:/temp/test2.jp2"};
        t2j.setParams(params);
        try {
            t2j.handleStream();
        }
        catch (FailedToHandlerStreamException e) {
            e.printStackTrace();
        }
    }
}

