/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.compress;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.core.sdk.utils.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Compress {
    private static final int BUFFER = 4096;

    public static InputStream compressDir(String directory, String relativePathToRemove, String extension, boolean deflated) throws Exception {
        return Compress.compressDir(directory, relativePathToRemove, null, extension, null, null, null, deflated);
    }

    public static InputStream compressDir(String directory, String relativePathToRemove, boolean deflated) throws Exception {
        return Compress.compressDir(directory, relativePathToRemove, null, null, null, null, null, deflated);
    }

    public static InputStream compressDir(String directory, String relativePathToRemove, String prefix, String extension) throws Exception {
        return Compress.compressDir(directory, relativePathToRemove, prefix, extension, null, null, null, true);
    }

    public static InputStream compressDir(String directory, String relativePathToRemove, String prefix, String extension, boolean deflated) throws Exception {
        return Compress.compressDir(directory, relativePathToRemove, prefix, extension, null, null, null, deflated);
    }

    public static InputStream compressDir(String directory, String relativePathToRemove, String prefix, String extension, String extension1) throws Exception {
        return Compress.compressDir(directory, relativePathToRemove, prefix, extension, extension1, null, null, true);
    }

    public static InputStream compressDir(String directory, String relativePathToRemove, String prefix, String extension, String extension1, boolean deflated) throws Exception {
        return Compress.compressDir(directory, relativePathToRemove, prefix, extension, extension1, null, null, deflated);
    }

    public static InputStream compressDirExclude(String directory, String relativePathToRemove, String prefix, String extension, String extension1, String excludeExtension, boolean defalted) throws Exception {
        return Compress.compressDir(directory, relativePathToRemove, prefix, extension, extension1, excludeExtension, null, defalted);
    }

    public static void compressDirToStreamExclude(String directory, String relativePathToRemove, String prefix, String extension, String extension1, String excludeExtension, OutputStream out) throws Exception {
        Compress.compressDir(directory, relativePathToRemove, prefix, extension, extension1, excludeExtension, out, true);
    }

    public static void compressDirToStreamExclude(String directory, String relativePathToRemove, String prefix, String extension, String extension1, String excludeExtension, OutputStream out, boolean defalted) throws Exception {
        Compress.compressDir(directory, relativePathToRemove, prefix, extension, extension1, excludeExtension, out, defalted);
    }

    public static void compressDirToStream(String directory, String relativePathToRemove, String prefix, String extension, OutputStream out) throws Exception {
        Compress.compressDir(directory, relativePathToRemove, prefix, extension, null, null, out, true);
    }

    public static void compressDirToStream(List files, boolean ignoreIoError, String relativePathToRemove, OutputStream out) throws Exception {
        Compress.compressDir(files, ignoreIoError, relativePathToRemove, null, out, true);
    }

    public static void compressDirToStream(String directory, String relativePathToRemove, String prefix, String extension, OutputStream out, boolean deflated) throws Exception {
        Compress.compressDir(directory, relativePathToRemove, prefix, extension, null, null, out, deflated);
    }

    private static InputStream compressDir(String directory, String relativePathToRemove, String prefix, String extension, String extension1, String excludeExtension, OutputStream out, boolean deflated) throws Exception {
        ArrayList filesList = new ArrayList(10);
        if (extension == null) {
            FileUtil.listFilesRecursive(directory, filesList);
        } else {
            FileUtil.listFilesRecursive(directory, filesList, extension);
        }
        if (extension1 != null) {
            ArrayList lTempList = new ArrayList(10);
            FileUtil.listFilesRecursive(directory, lTempList, extension1);
            filesList.addAll(lTempList);
        }
        if (excludeExtension != null) {
            ArrayList lExcludeList = new ArrayList(5);
            FileUtil.listFilesRecursive(directory, lExcludeList, excludeExtension);
            filesList.removeAll(lExcludeList);
        }
        if (out == null) {
            ByteArrayOutputStream dest = new ByteArrayOutputStream();
            Compress.compressDir(filesList, false, relativePathToRemove, prefix, dest, deflated);
            return new ByteArrayInputStream(dest.toByteArray());
        }
        Compress.compressDir(filesList, false, relativePathToRemove, prefix, out, deflated);
        return null;
    }

    public static InputStream compressDir(List files, boolean ignoreIoError, String relativePathToRemove) throws Exception {
        return Compress.compressDir(files, ignoreIoError, relativePathToRemove, true);
    }

    public static InputStream compressDir(List files, boolean ignoreIoError, String relativePathToRemove, boolean defalted) throws Exception {
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        Compress.compressDir(files, ignoreIoError, relativePathToRemove, null, dest, defalted);
        return new ByteArrayInputStream(dest.toByteArray());
    }

    private static void compressDir(List files, boolean ignoreIoError, String relativePathToRemove, String prefix, OutputStream out, boolean deflated) throws Exception {
        if (relativePathToRemove != null && !(relativePathToRemove = new File(relativePathToRemove).getAbsolutePath()).endsWith(File.separator)) {
            relativePathToRemove = relativePathToRemove + File.separator;
        }
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(out));
        zos.setMethod(8);
        if (!deflated) {
            zos.setLevel(0);
        }
        int size = files.size();
        String filePath = null;
        try {
            for (int i = 0; i < size; ++i) {
                filePath = (String)files.get(i);
                try {
                    Compress.addEntry(filePath, relativePathToRemove, prefix, zos, ignoreIoError);
                    continue;
                }
                catch (IOException ioe) {
                    if (ignoreIoError) continue;
                    throw ioe;
                }
            }
            zos.close();
        }
        catch (IOException ioe) {
            throw new Exception(ioe.getMessage(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(String filePath, String relativePathToRemove, String prefix, ZipOutputStream zos, boolean ignoreIoError) throws IOException {
        BufferedInputStream origin = null;
        FileInputStream fi = new FileInputStream(filePath);
        BufferedInputStream bis = new BufferedInputStream(fi, 4096);
        String path = filePath;
        if (relativePathToRemove != null) {
            path = StringUtils.replaceSubString(filePath, relativePathToRemove, "");
            if (prefix != null) {
                path = prefix + File.separator + path;
            }
        }
        try {
            if (ignoreIoError) {
                File file = new File(filePath);
                ByteArrayOutputStream baos = new ByteArrayOutputStream((int)file.length());
                IOUtil.copy((InputStream)bis, (OutputStream)baos);
                ZipEntry entry = new ZipEntry(path);
                zos.putNextEntry(entry);
                IOUtil.copy(baos.toByteArray(), (OutputStream)zos);
            } else {
                origin = bis;
                ZipEntry entry = new ZipEntry(path);
                zos.putNextEntry(entry);
                IOUtil.copy((InputStream)origin, (OutputStream)zos);
            }
        }
        finally {
            bis.close();
        }
        zos.closeEntry();
    }

    public static void decompress(String filePath, String relativePath) throws Exception {
        Compress.decompress(filePath, relativePath, null);
    }

    public static void decompress(String filePath, String relativePath, ArrayList exctractedFiles) throws Exception {
        ExLogger log = ExLogger.getExLogger(Compress.class);
        log.debug((Object)("Start decompress.  Parameters are 1. filePath=" + filePath + " 2. relativePath=" + relativePath), new String[0]);
        File currentFile = null;
        ZipFile zipfile = new ZipFile(filePath);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            BufferedOutputStream dest;
            FileOutputStream fos;
            BufferedInputStream is;
            block5: {
                ZipEntry entry = e.nextElement();
                String relativeName = entry.getName();
                log.debug((Object)("Zip Entry=" + relativeName), new String[0]);
                relativeName = File.separatorChar == '\\' ? relativeName.replace('/', File.separatorChar) : relativeName.replace('\\', File.separatorChar);
                currentFile = new File(relativePath, relativeName);
                log.debug((Object)("Extract Path=" + currentFile), new String[0]);
                if (entry.isDirectory()) {
                    currentFile.mkdirs();
                    continue;
                }
                currentFile.getParentFile().mkdirs();
                if (exctractedFiles != null) {
                    exctractedFiles.add(currentFile.getAbsolutePath());
                }
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                fos = new FileOutputStream(currentFile);
                dest = new BufferedOutputStream(fos, 4096);
                try {
                    IOUtil.copy((InputStream)is, (OutputStream)dest);
                }
                catch (IOException ioe) {
                    log.warn((Object)("Problem with file=" + currentFile), new String[0]);
                    if (currentFile == null) break block5;
                    currentFile.delete();
                }
            }
            dest.close();
            fos.close();
            is.close();
        }
        zipfile.close();
        log.debug((Object)"End decompress", new String[0]);
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> files = new ArrayList<String>();
            files.add("w:\\SPyramidDS.xml");
            files.add("W:\\nwindDS.xml");
            files.add("w:\\SPyramidList.xml.xml");
            InputStream inputStream = Compress.compressDir(files, true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

