/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.deposit;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.shared.dataObjects.KeyValuePair;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.parser.CoreIEParserImpl;
import com.exlibris.core.sdk.parser.IEParserException;
import com.exlibris.digitool.common.dnx.DNXConstants;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxDocumentFactory;
import com.exlibris.digitool.infrastructure.utils.Checksummer;
import com.exlibris.digitool.repository.dataObjects.ExtendedFileWrapper;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.repository.dps.model.StructMapTree;
import com.exlibris.repository.persistence.digitalentity.HDeStreamRef;
import gov.loc.mets.AmdSecType;
import gov.loc.mets.DivType;
import gov.loc.mets.FileType;
import gov.loc.mets.MdSecType;
import gov.loc.mets.MetsDocument;
import gov.loc.mets.MetsType;
import gov.loc.mets.StructMapType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;

public class IEParserImpl
extends CoreIEParserImpl
implements IEParser {
    private static final String TABLE_OF_CONTENTS = "Table of Contents";
    private static final ExLogger log = ExLogger.getExLogger(IEParser.class);
    private static final String IE = "ie";
    public static final String STRUCT_MAP_TYPE = "PHYSICAL";
    public static final String DIV1_LABEL = "collection";
    public static final String AMD_SUFFIX = "-amd";
    public static final String DMD_SUFFIX = "-dmd";
    public static final String STRUCT_MAP_PREFIX = "";
    public static final String TECH_SUFFIX = "-tech";
    public static final String BITSTREAM = "-bitstream";
    public static final String DIGIPROV_SUFFIX = "-digiprov";
    public static final String RIGHTS_SUFFIX = "-rights";
    public static final String SOURCE_SUFFIX = "-source";
    public static final String FILE_PREFIX = "file://";
    public static final String CONNECTOR = "-";
    private static final String PRESERVATION_MASTER = "PRESERVATION_MASTER";

    public IEParserImpl(MetsDocument metsDoc) {
        super(metsDoc);
    }

    @Override
    protected MetsDocument.Mets getMets() {
        return this.mets;
    }

    @Override
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, String pt) throws IEParserException {
        int newFileGrpCount = this.getFileGrpCount() + 1;
        String id = "rep" + newFileGrpCount;
        DnxDocument dnx = DnxDocumentFactory.getInstance().createDnxDocument();
        dnx.updateSectionKey(DNXConstants.GENERALREPCHARACTERISTICS.PRESERVATIONTYPE, pt);
        if (ut == null) {
            ut = Enum.UsageType.VIEW;
        }
        dnx.updateSectionKey(DNXConstants.GENERALREPCHARACTERISTICS.USAGETYPE, ut.name());
        return this.addNewFileGrp(ut, pt, id, dnx, false, null);
    }

    @Override
    @Deprecated
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, Enum.PreservationType pt) throws IEParserException {
        return this.addNewFileGrp(ut, pt.name());
    }

    @Override
    public AmdSecType getBitStreamsSection(String fileContainerId) throws IEParserException {
        return this.getAmd(fileContainerId + BITSTREAM + AMD_SUFFIX, false);
    }

    @Override
    public MdSecType[] getBitStreamSections(String byteStreamId) throws IEParserException {
        AmdSecType amdSecType = this.getAmd(byteStreamId + BITSTREAM + AMD_SUFFIX, false);
        if (amdSecType == null) {
            return new MdSecType[0];
        }
        return amdSecType.getTechMDArray();
    }

    @Override
    public AmdSecType addBitStreamsSection(String byteStreamId) {
        AmdSecType amdSecType = this.mets.addNewAmdSec();
        amdSecType.setID(byteStreamId + BITSTREAM + AMD_SUFFIX);
        this.addAmdSecToMap(amdSecType);
        return amdSecType;
    }

    @Override
    public void addBitStream(String byteStreamId, String bitStreamId, DnxDocument dnx) throws IEParserException {
        AmdSecType amdSecType = this.getAmd(byteStreamId + BITSTREAM + AMD_SUFFIX, true);
        MdSecType mdSecType = amdSecType.addNewTechMD();
        MdSecType.MdWrap mdWrap = mdSecType.addNewMdWrap();
        mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.OTHER);
        mdWrap.setOTHERMDTYPE("dnx");
        mdWrap.addNewXmlData();
        mdSecType.setID(byteStreamId + BITSTREAM + CONNECTOR + bitStreamId + AMD_SUFFIX + TECH_SUFFIX);
        XmlObject xObj = this.getXmlObject(dnx.getDnxDocumentForTechMd().toString());
        mdSecType.getMdWrap().getXmlData().set(xObj);
    }

    @Override
    @Deprecated
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, Enum.PreservationType pt, String id, DnxDocument dnx) throws IEParserException {
        return this.addNewFileGrp(ut, pt.name(), id, dnx, false, null);
    }

    @Override
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, String pt, String id, DnxDocument dnx) throws IEParserException {
        return this.addNewFileGrp(ut, pt, id, dnx, false, null);
    }

    @Override
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, String pt, String id, DnxDocument dnx, boolean useRef, String idForRef) throws IEParserException {
        if (pt == null) {
            pt = PRESERVATION_MASTER;
        }
        if (ut == null) {
            ut = Enum.UsageType.VIEW;
        }
        if (this.mets.getFileSec() == null) {
            this.mets.addNewFileSec();
        }
        MetsType.FileSec.FileGrp fileGrp = this.mets.getFileSec().addNewFileGrp();
        fileGrp.setID(id);
        this.setDnx(id, dnx, useRef, idForRef);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        fileGrp.setADMID(al);
        this.addFileGrpToMap(fileGrp);
        return fileGrp;
    }

    @Override
    public DnxDocument getDnxParser() {
        return DnxDocumentFactory.getInstance().createDnxDocument();
    }

    @Override
    public DnxDocument getFileDnx(String id) throws IEParserException {
        if (this.mets != null && this.getFile(id) != null && this.getFile(id).getADMID() != null) {
            return this.getDnx((String)this.getFile(id).getADMID().get(0));
        }
        return null;
    }

    @Override
    public DnxDocument getFileGrpDnx(String id) throws IEParserException {
        if (this.mets != null) {
            return this.getDnx((String)this.getFileGrp(id).getADMID().get(0));
        }
        return null;
    }

    @Override
    public DnxDocument getIeDnx() throws IEParserException {
        if (this.mets != null) {
            return this.getDnx("ie-amd");
        }
        return null;
    }

    @Override
    public void setFileDnx(DnxDocument dnx, String id) throws IEParserException {
        this.setFileDnx(dnx, id, false, null);
    }

    @Override
    public void setFileDnx(DnxDocument dnx, String id, boolean useRef, String idForRef) throws IEParserException {
        this.setDnx(id, dnx, useRef, idForRef);
        FileType file = this.getFile(id);
        if (file != null && file.getADMID() == null) {
            ArrayList<String> al = new ArrayList<String>();
            al.add(file.getID() + AMD_SUFFIX);
            file.setADMID(al);
        }
    }

    @Override
    public void setFileGrpDnx(DnxDocument dnx, String id) throws IEParserException {
        this.setFileGrpDnx(dnx, id, false, null);
    }

    @Override
    public void setFileGrpDnx(DnxDocument dnx, String id, boolean useRef, String idForRef) throws IEParserException {
        this.setDnx(id, dnx, useRef, idForRef);
    }

    @Override
    public void setIeDnx(DnxDocument dnx) throws IEParserException {
        this.setDnx(IE, dnx, false, null);
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label) throws IEParserException {
        String id = this.getFileId(fileGrp);
        DnxDocument dnx = DnxDocumentFactory.getInstance().createDnxDocument();
        dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.LABEL, label);
        dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.FILEMIMETYPE, mimeType);
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, id, dnx);
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String groupId) throws IEParserException {
        String id = this.getFileId(fileGrp);
        DnxDocument dnx = DnxDocumentFactory.getInstance().createDnxDocument();
        dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.LABEL, label);
        dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.FILEMIMETYPE, mimeType);
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, groupId, id, dnx);
    }

    @Override
    public String getFileId(MetsType.FileSec.FileGrp fileGrp) {
        int newFileCount = this.getFileCount(fileGrp) + 1;
        String id = "fid" + newFileCount + CONNECTOR + fileGrp.getID().replace("rep", STRUCT_MAP_PREFIX);
        return id;
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String id, DnxDocument dnx) throws IEParserException {
        FileType file = fileGrp.addNewFile();
        file.setID(id);
        FileType.FLocat flocat = file.addNewFLocat();
        flocat.setLOCTYPE(FileType.FLocat.LOCTYPE.URL);
        flocat.setHref(fileLocation);
        this.setDnx(id, dnx, false, null);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        file.setADMID(al);
        this.addFileTypeToMap(file);
        return file;
    }

    @Override
    public FileType addNewLimitedFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, long size, String id) throws IEParserException {
        FileType file = fileGrp.addNewFile();
        file.setID(id);
        file.setSIZE(size);
        file.setMIMETYPE(mimeType);
        this.addFileTypeToMap(file);
        return file;
    }

    @Override
    public FileType addNewLimitedFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, long size, String id, String fileLocation) throws IEParserException {
        FileType file = fileGrp.addNewFile();
        file.setID(id);
        file.setSIZE(size);
        file.setMIMETYPE(mimeType);
        FileType.FLocat flocat = file.addNewFLocat();
        flocat.setLOCTYPE(FileType.FLocat.LOCTYPE.URL);
        flocat.setHref(fileLocation);
        this.addFileTypeToMap(file);
        return file;
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String id, String groupId, DnxDocument dnx, boolean isDCValid) throws IEParserException {
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, id, groupId, dnx, isDCValid, false, null);
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String id, String groupId, DnxDocument dnx, boolean isDCValid, boolean useRef, String idForRef) throws IEParserException {
        FileType file = fileGrp.addNewFile();
        file.setID(id);
        if (!com.exlibris.core.sdk.strings.StringUtils.isEmptyString(groupId)) {
            file.setGROUPID(groupId);
        }
        FileType.FLocat flocat = file.addNewFLocat();
        flocat.setLOCTYPE(FileType.FLocat.LOCTYPE.URL);
        flocat.setHref(fileLocation);
        if (dnx != null) {
            if (StringUtils.isNotEmpty((String)label)) {
                dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.LABEL, label);
            }
            if (StringUtils.isNotEmpty((String)mimeType)) {
                dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.FILEMIMETYPE, mimeType);
            }
        }
        this.setDnx(id, dnx, useRef, idForRef);
        if (isDCValid) {
            ArrayList<String> al1 = new ArrayList<String>();
            al1.add(this.getFileDmdId(id));
            file.setDMDID(al1);
        }
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        file.setADMID(al);
        this.addFileTypeToMap(file);
        return file;
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String id, String groupId, DnxDocument dnx) throws IEParserException {
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, id, groupId, dnx, false);
    }

    @Override
    public void fixIdNaming() throws IEParserException {
        boolean beenChanged = false;
        MetsType.FileSec.FileGrp[] fileGrp = null;
        try {
            fileGrp = this.mets.getFileSec().getFileGrpArray();
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        for (int i = 0; i < fileGrp.length; ++i) {
            beenChanged = false;
            int fileGrpCount = i + 1;
            String correctFileGrpId = "rep" + fileGrpCount;
            if (!fileGrp[i].getID().equals(correctFileGrpId)) {
                if (fileGrp[i].getADMID().get(0).toString() != null) {
                    this.updateAmdIds(correctFileGrpId, fileGrp[i].getADMID().get(0).toString());
                }
                fileGrp[i].setID(correctFileGrpId);
                beenChanged = true;
            }
            FileType[] file = fileGrp[i].getFileArray();
            for (int j = 0; j < file.length; ++j) {
                int fileCount = j + 1;
                String correctFileId = "fid" + fileCount + CONNECTOR + fileGrp[i].getID().replace("rep", STRUCT_MAP_PREFIX);
                if (file[j].getID().equals(correctFileId)) continue;
                if (file[j].getADMID().get(0).toString() != null) {
                    this.updateAmdIds(correctFileId, file[j].getADMID().get(0).toString());
                }
                file[j].setID(correctFileId);
                beenChanged = true;
            }
            if (!beenChanged) continue;
            this.generateStructMap(fileGrp[i], this.getStructMapLabel(fileGrp[i].getID()));
        }
    }

    private String getStructMapLabel(String grpId) {
        String grpLabel = null;
        StructMapType smt = this.getStructMap(grpId);
        if (smt != null) {
            grpLabel = smt.getDiv().getLabel();
        }
        return grpLabel;
    }

    @Override
    public void generateChecksum(String filesRootFolder, String checksumType) throws IEParserException {
        String fullPath = null;
        DnxDocument dnx = null;
        MetsType.FileSec.FileGrp[] fileGrp = null;
        try {
            fileGrp = this.mets.getFileSec().getFileGrpArray();
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        for (int i = 0; i < fileGrp.length; ++i) {
            FileType[] file = fileGrp[i].getFileArray();
            for (int j = 0; j < file.length; ++j) {
                FileType.FLocat[] flocat = file[j].getFLocatArray();
                for (int k = 0; k < flocat.length; ++k) {
                    if (!((Object)((Object)flocat[k].getLOCTYPE())).equals((Object)FileType.FLocat.LOCTYPE.URL)) continue;
                    String path = flocat[k].getDomNode().getAttributes().getNamedItem("href").getNodeValue();
                    if (path.toLowerCase().startsWith(FILE_PREFIX)) {
                        path = path.substring(7);
                    }
                    if (path.trim().charAt(0) != File.separatorChar) {
                        path = File.separator + path;
                    }
                    fullPath = filesRootFolder + path;
                }
                File def = new File(fullPath);
                Checksummer mcs = null;
                try {
                    mcs = new Checksummer(def);
                }
                catch (FileNotFoundException e) {
                    throw new IEParserException(IEParserException.Descriptor.FILE_NOT_FOUND_EXCEPTION, (Throwable)e);
                }
                catch (IOException e) {
                    throw new IEParserException(IEParserException.Descriptor.IO_EXCEPTION, (Throwable)e);
                }
                dnx = this.getFileDnx(file[j].getID());
                dnx = dnx == null ? DnxDocumentFactory.getInstance().createDnxDocument() : dnx;
                dnx.updateSectionKey(DNXConstants.FILEFIXITY.FIXITYTYPE, checksumType);
                try {
                    dnx.updateSectionKey(DNXConstants.FILEFIXITY.FIXITYVALUE, mcs.getChecksum(checksumType));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IEParserException(IEParserException.Descriptor.NO_SUCH_ALGORITHM_EXCEPTION, (Throwable)e);
                }
                this.setDnx(file[j].getID(), dnx, false, null);
                if (file[j].getADMID() != null) continue;
                ArrayList<String> al = new ArrayList<String>();
                al.add(file[j].getID() + AMD_SUFFIX);
                file[j].setADMID(al);
            }
        }
    }

    @Override
    public void updateSize(String filesRootFolder) throws IEParserException {
        String fullPath = null;
        DnxDocument dnx = null;
        MetsType.FileSec.FileGrp[] fileGrp = null;
        try {
            fileGrp = this.mets.getFileSec().getFileGrpArray();
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        for (int i = 0; i < fileGrp.length; ++i) {
            FileType[] file = fileGrp[i].getFileArray();
            for (int j = 0; j < file.length; ++j) {
                FileType.FLocat[] flocat = file[j].getFLocatArray();
                for (int k = 0; k < flocat.length; ++k) {
                    if (!((Object)((Object)flocat[k].getLOCTYPE())).equals((Object)FileType.FLocat.LOCTYPE.URL)) continue;
                    String path = flocat[k].getDomNode().getAttributes().getNamedItem("href").getNodeValue();
                    if (path.toLowerCase().startsWith(FILE_PREFIX)) {
                        path = path.substring(7);
                    }
                    if (path.trim().charAt(0) != File.separatorChar) {
                        path = File.separator + path;
                    }
                    fullPath = filesRootFolder + path;
                }
                File def = new File(fullPath);
                dnx = this.getFileDnx(file[j].getID());
                dnx = dnx == null ? DnxDocumentFactory.getInstance().createDnxDocument() : dnx;
                dnx.updateSectionKey(DNXConstants.GENERALFILECHARACTERISTICS.FILESIZEBYTES, String.valueOf(def.length()));
                this.setDnx(file[j].getID(), dnx, false, null);
                if (file[j].getADMID() != null) continue;
                ArrayList<String> al = new ArrayList<String>();
                al.add(file[j].getID() + AMD_SUFFIX);
                file[j].setADMID(al);
            }
        }
    }

    @Override
    public void generateStructMap(MetsType.FileSec.FileGrp fileGrp, String label) throws IEParserException {
        String generatedStructMapDiv2Label = TABLE_OF_CONTENTS;
        this.generateStructMap(fileGrp, label, generatedStructMapDiv2Label);
    }

    @Override
    public void generateStructMap(MetsType.FileSec.FileGrp fileGrp, String label1, String label2) throws IEParserException {
        if (fileGrp == null) {
            MetsType.FileSec.FileGrp[] fileGrp2 = null;
            try {
                fileGrp2 = this.mets.getFileSec().getFileGrpArray();
            }
            catch (NullPointerException e) {
                throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
            }
            for (int i = 0; i < fileGrp2.length; ++i) {
                this.generateStructMapFileGrp(fileGrp2[i], label1, label2);
            }
        } else {
            this.generateStructMapFileGrp(fileGrp, label1, label2);
        }
    }

    private DnxDocument getDnx(AmdSecType amd) throws IEParserException {
        DnxDocument techMdDnx = null;
        DnxDocument digiprovMdDnx = null;
        DnxDocument rightsMdDnx = null;
        DnxDocument sourceMdDnx = null;
        try {
            if (amd.getTechMDArray().length != 0) {
                MdSecType.MdWrap techMdWrap = amd.getTechMDArray(0).getMdWrap();
                techMdDnx = this.getDnxFromMdWrap(techMdWrap);
            }
            if (amd.getDigiprovMDArray().length != 0) {
                MdSecType.MdWrap digiprovMdWrap = amd.getDigiprovMDArray(0).getMdWrap();
                digiprovMdDnx = this.getDnxFromMdWrap(digiprovMdWrap);
            }
            if (amd.getRightsMDArray().length != 0 && amd.getRightsMDArray(0).getMdWrap() != null) {
                MdSecType.MdWrap rightsMdWrap = amd.getRightsMDArray(0).getMdWrap();
                rightsMdDnx = this.getDnxFromMdWrap(rightsMdWrap);
            }
            if (amd.getSourceMDArray().length != 0 && amd.getSourceMDArray(0).getMdWrap() != null) {
                MdSecType.MdWrap sourceMdWrap = amd.getSourceMDArray(0).getMdWrap();
                sourceMdDnx = this.getDnxFromMdWrap(sourceMdWrap);
            }
        }
        catch (Exception e) {
            log.error("Failed parsing dnx metadata from METS amd sec " + amd.getID(), new String[0]);
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
        DnxDocument dnx = DnxDocumentFactory.getInstance().createDnxDocument();
        dnx.mergeDnxDocuments(techMdDnx, digiprovMdDnx, rightsMdDnx, sourceMdDnx);
        return dnx;
    }

    private DnxDocument getDnxFromMdWrap(MdSecType.MdWrap mdWrap) {
        DnxDocument dnx = null;
        if (mdWrap != null && this.isDnxMdWrap(mdWrap)) {
            dnx = DnxDocumentFactory.getInstance().parse(mdWrap.getXmlData().xmlText());
        }
        return dnx;
    }

    private DnxDocument getDnx(String id) throws IEParserException {
        if (this.getAmd(id, false) != null) {
            return this.getDnx(this.getAmd(id, false));
        }
        return null;
    }

    private void setDnx(String id, DnxDocument dnx, boolean useRef, String idForRef) throws IEParserException {
        if (dnx == null && !useRef) {
            return;
        }
        AmdSecType amd = this.getAmd(id + AMD_SUFFIX, true, useRef, idForRef);
        this.setDnxTechMd(useRef, idForRef, dnx, amd);
        this.setDnxDigiprovMd(useRef, idForRef, dnx, amd);
        this.setDnxRightsMd(useRef, idForRef, dnx, amd);
        this.setDnxSourceMd(useRef, idForRef, dnx, amd);
    }

    private void setDnxSourceMd(boolean useRef, String idForRef, DnxDocument dnx, AmdSecType amd) {
        try {
            XmlObject xObj = useRef ? null : this.getXmlObject(dnx.getDnxDocumentForSourceMd().toString());
            boolean findDnx = false;
            if (amd.getSourceMDArray().length == 0) {
                MdSecType newSourceMDSec = amd.addNewSourceMD();
                this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newSourceMDSec);
            } else {
                for (int i = 0; i < amd.getSourceMDArray().length; ++i) {
                    if (!useRef && !amd.getSourceMDArray(i).getMdWrap().getOTHERMDTYPE().equals("dnx")) continue;
                    this.updateProperWrapRef(useRef, idForRef, xObj, amd.getSourceMDArray(i));
                    findDnx = true;
                    break;
                }
                if (!findDnx && !useRef) {
                    MdSecType newSourceMDSec = amd.addNewSourceMD();
                    this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newSourceMDSec);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setDnxRightsMd(boolean useRef, String idForRef, DnxDocument dnx, AmdSecType amd) throws IEParserException {
        try {
            XmlObject xObj;
            XmlObject xmlObject = xObj = useRef ? null : this.getXmlObject(dnx.getDnxDocumentForRightshMd().toString());
            if (amd.getRightsMDArray().length == 0) {
                MdSecType newRightsMDSec = amd.addNewRightsMD();
                this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newRightsMDSec);
            } else {
                this.updateProperWrapRef(useRef, idForRef, xObj, amd.getRightsMDArray(0));
            }
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.ERROR_IN_RIGHTS_MD_ARRAY, (Throwable)e);
        }
    }

    private void setDnxDigiprovMd(boolean useRef, String idForRef, DnxDocument dnx, AmdSecType amd) throws IEParserException {
        try {
            XmlObject xObj;
            XmlObject xmlObject = xObj = useRef ? null : this.getXmlObject(dnx.getDnxDocumentForDigiprovMd().toString());
            if (amd.getDigiprovMDArray().length == 0) {
                MdSecType newDigiprovMDSec = amd.addNewDigiprovMD();
                this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newDigiprovMDSec);
            } else {
                this.updateProperWrapRef(useRef, idForRef, xObj, amd.getDigiprovMDArray(0));
            }
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.ERROR_IN_DIGIPROOV_MD_ARRAY, (Throwable)e);
        }
    }

    private void setDnxTechMd(boolean useRef, String idForRef, DnxDocument dnx, AmdSecType amd) throws IEParserException {
        try {
            XmlObject xObj;
            XmlObject xmlObject = xObj = useRef ? null : this.getXmlObject(dnx.getDnxDocumentForTechMd().toString());
            if (amd.getTechMDArray().length == 0) {
                MdSecType newTechMDSec = amd.addNewTechMD();
                this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newTechMDSec);
            } else {
                this.updateProperWrapRef(useRef, idForRef, xObj, amd.getTechMDArray(0));
            }
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.ERROR_IN_TECH_MD_ARRAY, (Throwable)e);
        }
    }

    @Override
    public void generateStructMapFileGrp(MetsType.FileSec.FileGrp fileGrp, String label1, String label2, boolean inAddition) throws IEParserException {
        ArrayList<ExtendedFileWrapper> filesArray = new ArrayList<ExtendedFileWrapper>();
        FileType[] file = fileGrp.getFileArray();
        for (int i = 0; i < file.length; ++i) {
            ExtendedFileWrapper fileWrapper = new ExtendedFileWrapper(null, null, null, this.getFileDisplay(file[i].getID()), null, null, null, file[i].getID(), null, null, null, null);
            filesArray.add(fileWrapper);
        }
        DnxDocument dnx = null;
        dnx = this.getFileGrpDnx(fileGrp.getID());
        if (label1 == null) {
            label1 = this.getDefaultLabel(dnx);
        }
        this.buildStructMap(fileGrp.getID(), filesArray, label1, label2, inAddition, false);
    }

    private void generateStructMapFileGrp(MetsType.FileSec.FileGrp fileGrp, String label1, String label2) throws IEParserException {
        this.generateStructMapFileGrp(fileGrp, label1, label2, false);
    }

    private String getFileDisplay(String fileID) {
        String fileDisplay = fileID;
        try {
            DnxDocument dnx = this.getFileDnx(fileID);
            if (dnx != null && ((fileDisplay = dnx.getSectionKeyValue(DNXConstants.GENERALFILECHARACTERISTICS.LABEL)) == null || fileDisplay.equals(STRUCT_MAP_PREFIX)) && (fileDisplay = dnx.getSectionKeyValue(DNXConstants.GENERALFILECHARACTERISTICS.FILEORIGINALNAME)) != null) {
                fileDisplay = fileDisplay.substring(fileDisplay.lastIndexOf(92) + 1);
                fileDisplay = fileDisplay.substring(fileDisplay.lastIndexOf(47) + 1);
            }
        }
        catch (IEParserException e) {
            e.printStackTrace();
        }
        return fileDisplay;
    }

    @Override
    public String getDefaultLabel(DnxDocument dnx) {
        String preservationType = dnx.getDnxDocumentForTechMd().getSectionKeyValue(DNXConstants.GENERALREPCHARACTERISTICS.PRESERVATIONTYPE);
        try {
            CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
            List<HCodeTables> preservationTypeCodeTables = codeTableManager.findCodeTableCodeByTableNameAndCode("PreservationType", preservationType, "CRS00");
            if (preservationTypeCodeTables != null && !preservationTypeCodeTables.isEmpty()) {
                return preservationTypeCodeTables.get(0).getDescription();
            }
        }
        catch (Throwable codeTableManager) {
            // empty catch block
        }
        String res = com.exlibris.core.sdk.strings.StringUtils.captiliazeFirstLetter(preservationType);
        return res;
    }

    @Override
    public void enrichExternalSM() {
        StructMapType[] structMaps = this.getStructMapArray();
        for (int i = 0; i < structMaps.length; ++i) {
            StructMapType structMap = structMaps[i];
            this.enrichFilesInStructMap(structMap.getDiv(), null);
        }
    }

    @Override
    public ArrayList<String> getFilesArray(StructMapType smType) {
        DivType smDiv = smType.getDiv();
        ArrayList<String> fileList = new ArrayList<String>();
        List<DivType.Fptr> files = this.getFilesFromStructMap(smDiv);
        for (DivType.Fptr file : files) {
            fileList.add(file.getFILEID());
        }
        return fileList;
    }

    @Override
    public List<DivType.Fptr> getFilesFromStructMap(DivType smDiv) {
        List files1 = Arrays.asList(smDiv.getFptrArray());
        DivType[] divTypes = smDiv.getDivArray();
        for (int j = 0; j < divTypes.length; ++j) {
            List<DivType.Fptr> files2 = this.getFilesFromStructMap(divTypes[j]);
            files1 = ListUtils.union(files1, files2);
        }
        return files1;
    }

    @Override
    public List<Map<String, String>> getFilesFromStructMapInfo(DivType smDiv) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        List<DivType.Fptr> files1 = Arrays.asList(smDiv.getFptrArray());
        String label = smDiv.getLABEL();
        for (DivType.Fptr fptr : files1) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(fptr.getFILEID(), label);
            list.add(map);
        }
        DivType[] divTypes = smDiv.getDivArray();
        for (int j = 0; j < divTypes.length; ++j) {
            List<Map<String, String>> files2 = this.getFilesFromStructMapInfo(divTypes[j]);
            list = ListUtils.union(list, files2);
        }
        return list;
    }

    @Override
    public StructMapType buildStructMap(String repId, List<ExtendedFileWrapper> files, String label1, String label2, Boolean inAddition, Boolean forLogicalTemplate) throws IEParserException {
        StructMapType structMap = inAddition != false ? this.addAdditionalStructMap(repId, forLogicalTemplate) : this.addNewStructMap(repId);
        DivType div1 = structMap.addNewDiv();
        div1.setLABEL(label1);
        DivType div2 = div1.addNewDiv();
        div2.setLABEL(label2);
        for (ExtendedFileWrapper file : files) {
            DivType div3 = div2.addNewDiv();
            String fileStructMapLabel = forLogicalTemplate != false ? file.getFileName() : (com.exlibris.core.sdk.strings.StringUtils.notEmptyString(file.getFileStructMapLabel()) ? file.getFileStructMapLabel() : file.getFileLabel());
            div3.setLABEL(fileStructMapLabel);
            div3.setTYPE("FILE");
            div3.addNewFptr().setFILEID(file.getDestFilePid());
        }
        return structMap;
    }

    @Override
    public StructMapType buildPhysicalStructMap(String repId, Map<String, String> files, String label) throws IEParserException {
        StructMapType structMap = this.addNewStructMap(repId);
        DivType div1 = structMap.addNewDiv();
        div1.setLABEL(label);
        DivType div2 = div1.addNewDiv();
        div2.setLABEL(TABLE_OF_CONTENTS);
        for (String filePid : files.keySet()) {
            DivType div3 = div2.addNewDiv();
            div3.setLABEL(files.get(filePid));
            div3.setTYPE("FILE");
            div3.addNewFptr().setFILEID(filePid);
        }
        return structMap;
    }

    @Override
    public StructMapType buildLogicalStructMap(String fileGrpId, Map<String, KeyValuePair<String, String>> files, String label) throws Exception {
        String structMapId = this.getNextStructMapId(fileGrpId);
        ArrayList<HDeStreamRef> streamRefs = new ArrayList<HDeStreamRef>();
        for (String fileId : files.keySet()) {
            HDeStreamRef stream = new HDeStreamRef();
            stream.setPid(fileId);
            stream.setFileName(files.get(fileId).getKey());
            stream.setFileOriginalPath(files.get(fileId).getValue());
            streamRefs.add(stream);
        }
        StructMapTree logicalStructMapTree = new StructMapTree();
        logicalStructMapTree.setRepPid(fileGrpId);
        logicalStructMapTree.setRepLabel(label);
        logicalStructMapTree.addToTree(streamRefs);
        StructMapType logicalStructMap = logicalStructMapTree.toStructMap(structMapId);
        this.setStructMap(logicalStructMap);
        return logicalStructMap;
    }

    @Override
    public DivType enrichFilesInStructMap(DivType smDiv, HashMap<String, String> fileLabelsMap) {
        if (!(smDiv.getTYPE() != null && smDiv.getTYPE().toUpperCase().toUpperCase().equals("FILE") || smDiv.getFptrArray().length <= 0)) {
            List<DivType.Fptr> files1 = Arrays.asList(smDiv.getFptrArray());
            for (DivType.Fptr file : files1) {
                DivType fileDiv = smDiv.addNewDiv();
                fileDiv.setTYPE("FILE");
                if (fileLabelsMap != null) {
                    fileDiv.setLABEL(fileLabelsMap.get(file.getFILEID()));
                } else {
                    fileDiv.setLABEL(this.getFileDisplay(file.getFILEID()));
                }
                DivType.Fptr[] fptrArray = new DivType.Fptr[]{file};
                fileDiv.setFptrArray(fptrArray);
            }
            smDiv.setFptrArray(new DivType.Fptr[0]);
        }
        DivType[] divTypes = smDiv.getDivArray();
        for (int j = 0; j < divTypes.length; ++j) {
            this.enrichFilesInStructMap(divTypes[j], fileLabelsMap);
        }
        return smDiv;
    }

    @Override
    public DivType removeFilesFromSM(DivType smDiv, List<String> filesToRemovePID) {
        ArrayList<String> localfilesToRemovePID = new ArrayList<String>(filesToRemovePID);
        DivType[] divTypes = smDiv.getDivArray();
        ArrayList<DivType> validDivTypes = new ArrayList<DivType>();
        for (int j = 0; j < divTypes.length; ++j) {
            if (divTypes[j].getTYPE() == null || !divTypes[j].getTYPE().toUpperCase().equals("FILE") || !localfilesToRemovePID.contains(divTypes[j].getFptrArray(0).getFILEID())) {
                validDivTypes.add(divTypes[j]);
                continue;
            }
            localfilesToRemovePID.remove(divTypes[j].getFptrArray(0).getFILEID());
        }
        DivType[] validDiv = new DivType[validDivTypes.size()];
        validDiv = validDivTypes.toArray(validDiv);
        smDiv.setDivArray(validDiv);
        DivType.Fptr[] files1 = smDiv.getFptrArray();
        ArrayList<DivType.Fptr> validFilesList = new ArrayList<DivType.Fptr>();
        for (DivType.Fptr file : files1) {
            if (localfilesToRemovePID.contains(file.getFILEID())) {
                localfilesToRemovePID.remove(file.getFILEID());
                continue;
            }
            validFilesList.add(file);
        }
        DivType.Fptr[] validFiles = new DivType.Fptr[validFilesList.size()];
        validFiles = validFilesList.toArray(validFiles);
        smDiv.setFptrArray(validFiles);
        if (localfilesToRemovePID.size() > 0) {
            divTypes = smDiv.getDivArray();
            for (int j = 0; j < divTypes.length; ++j) {
                this.removeFilesFromSM(divTypes[j], localfilesToRemovePID);
            }
        }
        return smDiv;
    }

    @Override
    public List<String> getRepPidList() {
        ArrayList<String> repPidList = new ArrayList<String>();
        for (MetsType.FileSec.FileGrp filegrp : this.getFileGrpArray()) {
            repPidList.add(filegrp.getID());
        }
        return repPidList;
    }

    @Override
    public ArrayList<String> getFilesPidArrayFromSM(int index, String grpId) {
        ArrayList<String> fileList = new ArrayList<String>();
        DivType smDiv = this.getStructMapsByFileGrpId(grpId)[index].getDiv();
        List<DivType.Fptr> files = this.getFilesFromStructMap(smDiv);
        for (DivType.Fptr file : files) {
            fileList.add(file.getFILEID());
        }
        return fileList;
    }

    @Override
    public String getLabelOfFileFromSM(int index, String grpId, String pid) {
        DivType smDiv = this.getStructMapsByFileGrpId(grpId)[index].getDiv();
        return this.getLabelFromStructMap(smDiv, pid);
    }

    @Override
    public String getLabelFromStructMap(DivType smDiv, String pid) {
        String label = STRUCT_MAP_PREFIX;
        List<DivType.Fptr> files1 = Arrays.asList(smDiv.getFptrArray());
        if (files1.size() == 1 && files1.get(0).getFILEID().equals(pid)) {
            label = smDiv.getLABEL();
            if (label == null || label.isEmpty()) {
                label = pid;
            }
            return label;
        }
        DivType[] divTypes = smDiv.getDivArray();
        for (int j = 0; j < divTypes.length && (label = this.getLabelFromStructMap(divTypes[j], pid)).length() <= 0; ++j) {
        }
        return label;
    }

    @Override
    public void removeFileGrp(String grpId) throws IEParserException {
        FileType[] files = this.getFileArray(grpId);
        for (int i = 0; i < files.length; ++i) {
            this.removeAmdSec(files[i].getADMID().get(0).toString().split(CONNECTOR)[0]);
        }
        this.removeFGSec(grpId);
        this.removeAmdSec(grpId);
        this.removeFGDmdSec(grpId);
        this.removeFGStructMaps(grpId);
    }
}

