/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITFPP2
extends TiffProfileClassIT {
    public TiffProfileClassITFPP2() {
        this._profileText = "TIFF/IT-FP/P2 (ISO 12639:2003)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (tifd.getImageDescription() == null) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (!(bps == null || bps.length == 1 && (bps[0] == 4 || bps[0] == 8) || bps.length == 3 && bps[0] == 8 && bps[1] == 8 && bps[2] == 8 || bps.length == 4 && bps[0] == 8 && bps[1] == 8 && bps[2] == 8 && bps[3] == 8)) {
            return false;
        }
        long nsft = tifd.getNewSubfileType();
        if ((nsft & 8L) == 0L) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{0, 1, 2, 5})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, new int[]{3, 4, -1})) {
            return false;
        }
        if (!this.satisfiesOrientation(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesPlanarConfiguration(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, 1)) {
            return false;
        }
        int pint = niso.getColorSpace();
        int nInks = tifd.getNumberOfInks();
        if (!(pint != 5 || nInks == 4 && this.satisfiesDotRange(tifd, 0, 255))) {
            return false;
        }
        return tifd.getDocumentName() == null && niso.getScannerModelName() == null && tifd.getPageName() == null && niso.getHostComputer() == null && tifd.getSite() == null;
    }
}

