/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;
import com.sun.star.datatransfer.XTransferable;
import com.sun.star.datatransfer.XTransferableSupplier;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XController;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.view.XSelectionSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.document.DocumentFamily;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesSelectorFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagesSelectorFilter.class);
    private final List<Integer> pages;

    public PagesSelectorFilter(Integer ... pages) {
        this(Stream.of(pages).collect(Collectors.toSet()));
    }

    public PagesSelectorFilter(@NonNull Set<@NonNull Integer> pages) {
        AssertUtils.notEmpty(pages, (String)"pages must not be null nor empty");
        this.pages = new ArrayList<Integer>(pages);
    }

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws Exception {
        DocumentFamily family = LocalOfficeUtils.getDocumentFamilySilently(document);
        if (family != null) {
            switch (family) {
                case TEXT: {
                    LOGGER.debug("Applying the PagesSelectorFilter for a Text document");
                    Collections.sort(this.pages);
                    this.selectTextPages(Lo.qi(XTextDocument.class, document));
                    break;
                }
                case SPREADSHEET: {
                    LOGGER.debug("Applying the PagesSelectorFilter for a Calc document");
                    this.selectSheets(Lo.qi(XSpreadsheetDocument.class, document));
                    break;
                }
                case PRESENTATION: 
                case DRAWING: {
                    LOGGER.debug("Applying the PagesSelectorFilter for a {} document", (Object)(family == DocumentFamily.DRAWING ? "Draw" : "Impress"));
                    this.pages.sort(Collections.reverseOrder());
                    this.selectDrawPages(Lo.qi(XDrawPagesSupplier.class, document));
                }
            }
        }
        chain.doFilter(context, document);
    }

    private void copyPage(XTextDocument docText, int source, int target) throws Exception {
        if (source == target) {
            return;
        }
        XController ctrl = docText.getCurrentController();
        XTextCursor tc = docText.getText().createTextCursor();
        XTextViewCursor vc = Lo.qi(XTextViewCursorSupplier.class, ctrl).getViewCursor();
        XPageCursor pc = Lo.qi(XPageCursor.class, vc);
        tc.gotoStart(false);
        vc.gotoStart(false);
        pc.jumpToPage((short)source);
        tc.gotoRange(vc.getStart(), false);
        pc.jumpToEndOfPage();
        tc.gotoRange(vc.getStart(), true);
        XSelectionSupplier selectionSupplier = Lo.qi(XSelectionSupplier.class, ctrl);
        selectionSupplier.select((Object)tc);
        XTransferableSupplier transferableSupplier = Lo.qi(XTransferableSupplier.class, ctrl);
        XTransferable xTransferable = transferableSupplier.getTransferable();
        tc.gotoStart(false);
        vc.gotoStart(false);
        pc.jumpToPage((short)target);
        tc.gotoRange(vc.getStart(), false);
        pc.jumpToEndOfPage();
        tc.gotoRange(vc.getStart(), true);
        selectionSupplier.select((Object)tc);
        transferableSupplier.insertTransferable(xTransferable);
    }

    private void selectTextPages(XTextDocument doc) throws Exception {
        XController ctrl = doc.getCurrentController();
        int pageCount = (Integer)Props.getProperty(ctrl, "PageCount");
        int nextTargetPage = 1;
        for (int page : this.pages) {
            if (page <= 0 || page > pageCount) continue;
            this.copyPage(doc, page, nextTargetPage++);
        }
        int lastPage = nextTargetPage - 1;
        XTextCursor tc = doc.getText().createTextCursor();
        XTextViewCursor vc = Lo.qi(XTextViewCursorSupplier.class, ctrl).getViewCursor();
        XPageCursor pc = Lo.qi(XPageCursor.class, vc);
        tc.gotoStart(false);
        vc.gotoStart(false);
        pc.jumpToPage((short)lastPage);
        pc.jumpToEndOfPage();
        tc.gotoRange(vc.getEnd(), true);
        XSelectionSupplier selectionSupplier = Lo.qi(XSelectionSupplier.class, ctrl);
        selectionSupplier.select((Object)tc);
        XTransferableSupplier transSupplier = Lo.qi(XTransferableSupplier.class, ctrl);
        XTransferable trans = transSupplier.getTransferable();
        tc.gotoStart(false);
        tc.gotoEnd(true);
        selectionSupplier.select((Object)tc);
        transSupplier.insertTransferable(trans);
    }

    private void selectSheets(XSpreadsheetDocument doc) throws Exception {
        XSpreadsheets sheets = doc.getSheets();
        XIndexAccess indexedSheets = Lo.qi(XIndexAccess.class, sheets);
        int count = indexedSheets.getCount();
        for (int i = count - 1; i >= 0; --i) {
            XSpreadsheet sheet = Lo.qi(XSpreadsheet.class, indexedSheets.getByIndex(i));
            XNamed namedSheet = Lo.qi(XNamed.class, sheet);
            if (this.pages.contains(i + 1)) continue;
            sheets.removeByName(namedSheet.getName());
        }
    }

    private void selectDrawPages(XDrawPagesSupplier supplier) throws Exception {
        int pageCount;
        XDrawPages drawPages = supplier.getDrawPages();
        for (int i = pageCount = drawPages.getCount(); i > 0; --i) {
            if (this.pages.contains(i)) continue;
            drawPages.remove(Lo.qi(XDrawPage.class, drawPages.getByIndex(i - 1)));
        }
    }
}

