/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibrisgroup.xsd.dps.backoffice.service.ResponseDocument;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class XmlUtils {
    private static final ExLogger log = ExLogger.getExLogger(XmlUtils.class);
    private static final Pattern legalXMLCharsPattern = Pattern.compile("[^ -\ud7ff\ue000-\ufffd\u10000-\u10ffff\t\r\n]");

    public static String toXML(XmlObject xmlbean) {
        return XmlUtils.toXML(xmlbean, false);
    }

    public static String toXML(XmlObject xmlbean, boolean removeNameSpace) {
        XmlOptions opt = new XmlOptions();
        opt.setSavePrettyPrint();
        if (removeNameSpace) {
            opt.setUseDefaultNamespace();
        }
        return xmlbean.xmlText(opt);
    }

    public static String createXmlResponse(Long id) {
        ResponseDocument doc = ResponseDocument.Factory.newInstance();
        ResponseDocument.Response response = doc.addNewResponse();
        response.setId(id);
        response.setIsError(false);
        response.setErrorDescription(null);
        return XmlUtils.toXML(doc, true);
    }

    public static String createXmlResponse(boolean isError, String errorMessage) {
        ResponseDocument doc = ResponseDocument.Factory.newInstance();
        ResponseDocument.Response response = doc.addNewResponse();
        response.setIsError(isError);
        response.setErrorDescription(errorMessage);
        return XmlUtils.toXML(doc, true);
    }

    public static String createXmlResponse(String errorMessage) {
        return XmlUtils.createXmlResponse(true, errorMessage);
    }

    public static String createXmlResponse(List<String> errorMessage) {
        ResponseDocument doc = ResponseDocument.Factory.newInstance();
        ResponseDocument.Response response = doc.addNewResponse();
        response.setIsError(true);
        StringBuffer errorDescription = new StringBuffer();
        for (String error : errorMessage) {
            errorDescription.append(error + "\n");
        }
        response.setErrorDescription(errorDescription.toString());
        return XmlUtils.toXML(doc, true);
    }

    public static Long convertStringToLong(String field, String value) throws InfraException {
        if (value == null) {
            return null;
        }
        try {
            Long realLong = Long.valueOf(value);
            return realLong;
        }
        catch (NumberFormatException nfe) {
            Object[] params = new Object[]{field, value};
            log.error(MessageFormat.format("{0} can contain only values of the type Long. The value entered: {1} is invalid.", params), new String[0]);
            throw new InfraException(DescriptorConstants.WS_InvalidTypeLong, field);
        }
    }

    public static Integer convertStringToInteger(String field, String value) throws InfraException {
        if (value == null) {
            return null;
        }
        try {
            Integer realInteger = Integer.valueOf(value);
            return realInteger;
        }
        catch (NumberFormatException nfe) {
            Object[] params = new Object[]{field, value};
            log.error(MessageFormat.format("{0} can contain only values of the type Integer. The value entered: {1} is invalid.", params), new String[0]);
            throw new InfraException(DescriptorConstants.WS_InvalidTypeInteger, field);
        }
    }

    public static Boolean convertStringToBoolean(String field, String value) throws InfraException {
        if (value == null) {
            return null;
        }
        if ("y".equals(value.toLowerCase()) || "yes".equals(value.toLowerCase())) {
            value = "true";
        }
        if ("n".equals(value.toLowerCase()) || "no".equals(value.toLowerCase())) {
            value = "false";
        }
        try {
            Boolean realBoolean = Boolean.valueOf(value.toLowerCase());
            return realBoolean;
        }
        catch (Exception e) {
            Object[] params = new Object[]{field, value};
            log.error(MessageFormat.format("{0} can contain only values of the type Boolean. The value entered: {1} is invalid.", params), new String[0]);
            throw new InfraException(DescriptorConstants.WS_InvalidTypeBoolean, field);
        }
    }

    public static Calendar convertStringDateToCalender(String field, String source) throws InfraException {
        if (StringUtils.isEmptyString(source)) {
            return null;
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(XmlUtils.convertStringDateToDate(field, source));
            return cal;
        }
        catch (Exception e) {
            String dateFormat = null;
            GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            try {
                dateFormat = gpm.getParameter("repository", "system_date_format");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (StringUtils.isEmptyString(dateFormat)) {
                dateFormat = "dd/MM/yyyy";
            }
            Object[] params = new Object[]{field, dateFormat};
            log.error(MessageFormat.format("{0} can contain only values of the type Date (required format: {1}).", params), new String[0]);
            throw new InfraException(DescriptorConstants.WS_InvalidTypeDate, (Object)field, dateFormat);
        }
    }

    public static Date convertStringDateToDate(String field, String source) throws InfraException {
        if (source == null) {
            return null;
        }
        try {
            return DateHandler.parseDateByFormat(source, false);
        }
        catch (ParseException e) {
            String dateFormat = null;
            GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            try {
                dateFormat = gpm.getParameter("repository", "system_date_format");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (StringUtils.isEmptyString(dateFormat)) {
                dateFormat = "dd/MM/yyyy";
            }
            Object[] params = new Object[]{field, dateFormat};
            log.error(MessageFormat.format("{0} can contain only values of the type Date (required format: {1}).", params), new String[0]);
            throw new InfraException(DescriptorConstants.WS_InvalidTypeDate, (Object)field, dateFormat);
        }
    }

    public static Calendar convertDateToCalender(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String stripNonValidXMLCharacters(String in) {
        if (in == null) {
            return null;
        }
        return legalXMLCharsPattern.matcher(in).replaceAll("");
    }
}

