/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.FetchItem;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.domain.Version;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PayloadWriter {
    private static final Logger logger = LoggerFactory.getLogger(PayloadWriter.class);
    private static final Version VERSION_2_0 = new Version(2, 0);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    private PayloadWriter() {
    }

    static Path writeVersionDependentPayloadFiles(Bag bag, Path outputDir) throws IOException {
        Path bagitDir = outputDir;
        if (bag.getVersion().isSameOrNewer(VERSION_2_0)) {
            bagitDir = outputDir.resolve(".bagit");
            Files.createDirectories(bagitDir, new FileAttribute[0]);
            PayloadWriter.writePayloadFiles(bag.getPayLoadManifests(), bag.getItemsToFetch(), outputDir, bag.getRootDir());
        } else {
            Path dataDir = outputDir.resolve("data");
            Files.createDirectories(dataDir, new FileAttribute[0]);
            PayloadWriter.writePayloadFiles(bag.getPayLoadManifests(), bag.getItemsToFetch(), dataDir, bag.getRootDir().resolve("data"));
        }
        return bagitDir;
    }

    public static void writePayloadFiles(Set<Manifest> payloadManifests, List<FetchItem> fetchItems, Path outputDir, Path bagDataDir) throws IOException {
        logger.info(messages.getString("writing_payload_files"));
        Set<Path> fetchPaths = PayloadWriter.getFetchPaths(fetchItems, bagDataDir);
        for (Manifest payloadManifest : payloadManifests) {
            for (Path payloadFile : payloadManifest.getFileToChecksumMap().keySet()) {
                Path relativePayloadPath = bagDataDir.relativize(payloadFile);
                if (fetchPaths.contains(relativePayloadPath.normalize())) {
                    logger.info(messages.getString("skip_fetch_item_when_writing_payload"), (Object)payloadFile);
                    continue;
                }
                Path writeToPath = outputDir.resolve(relativePayloadPath);
                logger.debug(messages.getString("writing_payload_file_to_path"), (Object)payloadFile, (Object)writeToPath);
                Path parent = writeToPath.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.copy(payloadFile, writeToPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static Set<Path> getFetchPaths(List<FetchItem> fetchItems, Path bagDataDir) {
        HashSet<Path> fetchPaths = new HashSet<Path>();
        for (FetchItem fetchItem : fetchItems) {
            Path parent = bagDataDir.getParent();
            if (parent == null) continue;
            fetchPaths.add(bagDataDir.relativize(parent.resolve(fetchItem.getPath())));
        }
        return fetchPaths;
    }
}

