/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common;

import com.exlibris.core.infra.base.security.ContextConnection;
import com.exlibris.core.infra.base.security.CustomerInstitutionRetriever;
import java.sql.Connection;
import oracle.jdbc.driver.OracleConnection;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.transaction.TransactionDefinition;

public class JpaTransactionManager
extends org.springframework.orm.jpa.JpaTransactionManager {
    private static final long serialVersionUID = -595960138123166854L;
    private static final String DBG_START_PROCESSING_TIME = "DBG_START_PROCESSING_TIME";

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return false;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        super.doBegin(transaction, definition);
        JdbcTransactionObjectSupport txObject = (JdbcTransactionObjectSupport)transaction;
        Connection connection = null;
        if (txObject.getConnectionHolder() != null) {
            connection = txObject.getConnectionHolder().getConnection();
        }
        try {
            ContextConnection contextConnection = new ContextConnection((OracleConnection)connection.unwrap(Connection.class));
            ContextConnection.addSidToCurrentThread(contextConnection.getSid());
            CustomerInstitutionRetriever.addDebugObjectForCurrentThread(DBG_START_PROCESSING_TIME, System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        super.doCleanupAfterCompletion(transaction);
        ContextConnection.removeSidToCurrentThread();
        CustomerInstitutionRetriever.removeDebugInfoForCurrentThread();
    }
}

