/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.sax;

import com.exlibris.core.infra.common.sax.UnEscapeSequenceXMLFilter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxStripperDates
extends DefaultHandler {
    private FileWriter fw = null;
    private BufferedWriter out = null;
    private StringBuilder strippedDocument = null;
    private StringBuilder strippedCharacters = new StringBuilder();
    private boolean currElementEmpty = false;
    private static final String INDENTATION_CHAR = " ";
    private static final int INDENTATION_DIFF = 2;
    private int currIndentation = -2;
    private boolean hasSubElements = false;
    private static final String ID_ATTR = "id";
    private static final String AMD_TAG = "mets:amdSec";
    private static final String SECTION_TAG = "section";
    private static final String KEY_TAG = "key";
    private static final String MODIFIED_BY_TAG = "modifiedBy";
    private static final String MODIFICATION_DATE_TAG = "modificationDate";
    private static final String METADATA_VAL = "metaData";
    private static final String OBJECT_CHARACTERISTICS_VAL = "objectCharacteristics";
    private static final String FILE_AMD_SUFFIX = "-amd";
    private static final String FILE_ID_PREFIX = "FL";
    private static final String IE_VAL = "ie-amd";
    private static final String DNX_QNAME = "dnx";
    private static final String VERSION = "version";
    private boolean isUnderIeAmdSec = false;
    private boolean isUnderFileAmdSec = false;
    private boolean isUnderObjectCharacteristics = false;
    private boolean isUnderMetadata = false;
    private boolean isUnderModificationDate = false;
    private boolean isUnderModifiedBy = false;
    private boolean isFirstWriting = true;

    public SaxStripperDates() {
        this.strippedDocument = new StringBuilder();
    }

    private void appendCurrentText() {
        this.strippedDocument.append(this.strippedCharacters.toString().trim());
        this.strippedCharacters.setLength(0);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currElementEmpty = true;
        this.hasSubElements = false;
        boolean isIEID = false;
        boolean isFileID = false;
        boolean isObjectCharacteristics = false;
        boolean isMetadata = false;
        boolean isModificationDate = false;
        boolean isModifiedBy = false;
        this.appendCurrentText();
        this.currIndentation += 2;
        if (this.isFirstWriting) {
            this.strippedDocument.append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation)).append('<' + qName);
            this.isFirstWriting = false;
        } else {
            this.strippedDocument.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation)).append('<' + qName);
        }
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (qName.equals(DNX_QNAME)) {
                    if (!attributes.getQName(i).equals(VERSION)) {
                        this.strippedDocument.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
                    }
                } else {
                    this.strippedDocument.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
                }
                if (ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) && IE_VAL.equals(attributes.getValue(i))) {
                    isIEID = true;
                    continue;
                }
                if (ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) && attributes.getValue(i) != null && attributes.getValue(i).startsWith(FILE_ID_PREFIX) && attributes.getValue(i).endsWith(FILE_AMD_SUFFIX)) {
                    isFileID = true;
                    continue;
                }
                if (ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) && METADATA_VAL.equals(attributes.getValue(i))) {
                    isMetadata = true;
                    continue;
                }
                if (ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) && OBJECT_CHARACTERISTICS_VAL.equals(attributes.getValue(i))) {
                    isObjectCharacteristics = true;
                    continue;
                }
                if (ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) && MODIFICATION_DATE_TAG.equals(attributes.getValue(i))) {
                    isModificationDate = true;
                    continue;
                }
                if (!ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) || !MODIFIED_BY_TAG.equals(attributes.getValue(i))) continue;
                isModifiedBy = true;
            }
        }
        this.strippedDocument.append(">");
        if (AMD_TAG.equals(qName) && isIEID) {
            this.isUnderIeAmdSec = true;
        } else if (AMD_TAG.equals(qName) && isFileID) {
            this.isUnderFileAmdSec = true;
        } else if (SECTION_TAG.equals(qName) && isObjectCharacteristics) {
            this.isUnderObjectCharacteristics = true;
        } else if (SECTION_TAG.equals(qName) && isMetadata) {
            this.isUnderMetadata = true;
        } else if (KEY_TAG.equals(qName) && isModificationDate) {
            this.isUnderModificationDate = true;
        } else if (KEY_TAG.equals(qName) && isModifiedBy) {
            this.isUnderModifiedBy = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.appendCurrentText();
        if (this.currElementEmpty) {
            this.strippedDocument.setLength(this.strippedDocument.length() - 1);
            this.strippedDocument.append("/>");
        } else {
            if (this.hasSubElements) {
                this.strippedDocument.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation));
            }
            this.strippedDocument.append("</" + qName + '>');
        }
        this.currIndentation -= 2;
        this.currElementEmpty = false;
        this.hasSubElements = true;
        try {
            this.out.write(this.strippedDocument.toString());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this.strippedDocument.delete(0, this.strippedDocument.length());
        this.isUnderIeAmdSec &= !AMD_TAG.equals(qName);
        this.isUnderFileAmdSec &= !AMD_TAG.equals(qName);
        this.isUnderObjectCharacteristics &= !SECTION_TAG.equals(qName);
        this.isUnderMetadata &= !SECTION_TAG.equals(qName);
        this.isUnderModificationDate &= !KEY_TAG.equals(qName);
        this.isUnderModifiedBy &= !KEY_TAG.equals(qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.shouldBeStripped()) {
            this.strippedCharacters.append(ch, start, length);
            if (this.strippedCharacters.toString().trim().length() > 0) {
                this.currElementEmpty = false;
            }
        }
    }

    private boolean shouldBeStripped() {
        return (this.isUnderIeAmdSec || this.isUnderFileAmdSec) && this.isUnderObjectCharacteristics && this.isUnderModificationDate || this.isUnderIeAmdSec && this.isUnderMetadata && (this.isUnderModificationDate || this.isUnderModifiedBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream is, File path) throws SAXException, IOException {
        try {
            this.fw = new FileWriter(path);
            this.out = new BufferedWriter(this.fw);
            UnEscapeSequenceXMLFilter xmlFilter = new UnEscapeSequenceXMLFilter(XMLReaderFactory.createXMLReader());
            xmlFilter.setContentHandler(this);
            xmlFilter.parse(new InputSource(is));
        }
        finally {
            is.close();
            this.out.close();
            this.fw.close();
        }
    }
}

