/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import com.exlibris.core.infra.common.exceptions.ExlibrisException;
import com.exlibris.core.infra.common.exceptions.logging.Descriptor;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class ResourceBundleUtil {
    private static ExLogger log = ExLogger.getExLogger(ResourceBundleUtil.class);

    public static String getMessage(ResourceBundle resourceBundle, Descriptor descriptor) {
        String key = String.valueOf(descriptor.getId());
        return ResourceBundleUtil.getString(resourceBundle, key);
    }

    public static String getMessage(ResourceBundle resourceBundle, ExlibrisException exception) {
        String key = String.valueOf(exception.getDescriptor().getId());
        String msg = ResourceBundleUtil.getString(resourceBundle, key);
        return MessageFormat.format(msg, exception.getContext());
    }

    public static String getString(ResourceBundle resourceBundle, String key) {
        return ResourceBundleUtil.getString(resourceBundle, key, true);
    }

    public static String getString(ResourceBundle resourceBundle, String key, boolean checkValue) {
        String value = resourceBundle.getString(key);
        if (checkValue && key != null && key.split("\\.") != null && value.startsWith(key.split("\\.")[0])) {
            try {
                String temp = URLEncoder.encode(value, "UTF-8");
                if (!temp.replace("+", " ").equals(value)) {
                    value = temp;
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error("Problem encoding key", e, new String[0]);
                value = "";
            }
        }
        return value;
    }
}

