/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.validator;

import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.common.validator.AbsFormValidator;
import com.exlibris.core.infra.common.validator.ValidationResults;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegularExpressionFormValidator
extends AbsFormValidator {
    @Override
    public ValidationResults validate(String value) {
        return this.validate(value, this.getRegularExpression());
    }

    public ValidationResults validate(String value, String exp) {
        ValidationResults results = new ValidationResults();
        if (StringUtils.isEmptyString(value)) {
            results.setValid(true);
            return results;
        }
        Pattern pattern = Pattern.compile(exp);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            results.setErrorCode(this.getErrorCode());
            results.setErrorParams(this.getErrorParams());
            results.setValid(false);
        } else {
            results.setValid(true);
        }
        return results;
    }

    public abstract String getRegularExpression();

    public abstract String getErrorCode();

    public abstract Object[] getErrorParams();
}

