/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.customfields;

import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.model.customfields.CustomFieldConfiguration;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CustomFieldsUtils {
    private CustomFieldsUtils() {
    }

    public static Map<String, CustomFieldConfiguration> getCustomFieldConfiguration(String tableName, CodeTablesManager codeTablesMgr) {
        HashMap<String, CustomFieldConfiguration> fieldConfig = new HashMap<String, CustomFieldConfiguration>();
        List<HMappingTables> mtList = codeTablesMgr.findAllValuesForMappingTable(tableName);
        for (HMappingTables mappingTables : mtList) {
            CustomFieldConfiguration cfg = new CustomFieldConfiguration(mappingTables);
            fieldConfig.put(cfg.getColumnName(), cfg);
        }
        return fieldConfig;
    }

    public static boolean hasCustomFields(String tableName, CodeTablesManager codeTablesMgr) {
        boolean rtn = false;
        Map<String, CustomFieldConfiguration> cf = CustomFieldsUtils.getCustomFieldConfiguration(tableName, codeTablesMgr);
        Iterator<String> iterator = cf.keySet().iterator();
        while (iterator.hasNext()) {
            CustomFieldConfiguration customField = cf.get(iterator.next());
            if (!customField.isEnabled()) continue;
            rtn = true;
            break;
        }
        return rtn;
    }
}

