/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.locator;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringServiceLocator {
    private static ExLogger log = ExLogger.getExLogger(SpringServiceLocator.class);
    private ApplicationContext applicationContext;
    private static SpringServiceLocator ourInstance;

    public static SpringServiceLocator getInstance() {
        if (ourInstance == null) {
            ourInstance = new SpringServiceLocator();
        }
        return ourInstance;
    }

    private SpringServiceLocator() {
        this.init();
    }

    public void reset() {
        this.init();
    }

    private void init() {
        this.applicationContext = new ClassPathXmlApplicationContext(new String[]{"META-INF/spring/app-context.xml"}, false);
        log.info("Start scanning Jars for Spring Beans: ");
        ((ConfigurableApplicationContext)this.applicationContext).refresh();
        log.info("Done scanning Jars for Spring Beans.");
    }

    public <T> T lookUp(Class T) {
        return this.lookUp(T.getSimpleName(), T);
    }

    public <T> T lookUp(String lookupName, Class T) {
        return (T)this.applicationContext.getBean(lookupName + "/local", T);
    }
}

