/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.common.security.UserPrincipalRetriever;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class PdsHandleAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private static final String PDS_HANDLE = "pds_handle";

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return StringUtils.isNotBlank((String)request.getParameter(PDS_HANDLE));
    }

    protected String obtainUsername(HttpServletRequest request) {
        return request.getParameter(PDS_HANDLE);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        boolean isAuthenticated;
        boolean bl = isAuthenticated = UserPrincipalRetriever.getUserPrincipal() != null;
        if (isAuthenticated) {
            this.redirectWithoutPdsHandle(request, response);
            return null;
        }
        this.setPostOnly(false);
        return super.attemptAuthentication(request, response);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(authResult);
        this.redirectWithoutPdsHandle(request, response);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        this.redirectWithoutPdsHandle(request, response);
    }

    private void redirectWithoutPdsHandle(HttpServletRequest request, HttpServletResponse response) {
        try {
            String urlParams = "?";
            Set keySet = request.getParameterMap().keySet();
            for (String parameter : keySet) {
                if (PDS_HANDLE.equalsIgnoreCase(parameter)) continue;
                urlParams = urlParams + parameter + "=" + request.getParameter(parameter) + "&";
            }
            String urlWithoutPdsHandle = request.getRequestURL().toString() + urlParams.substring(0, urlParams.length() - 1);
            response.sendRedirect(urlWithoutPdsHandle);
        }
        catch (IOException e) {
            this.logger.error((Object)"Failed to redirect", (Throwable)e);
        }
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        HashMap<String, Common.AuthenticationMode> parameters = new HashMap<String, Common.AuthenticationMode>();
        parameters.put("authentication_mode", Common.AuthenticationMode.PDS);
        authRequest.setDetails(parameters);
    }
}

