/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.config;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.interfaces.Resettable;
import com.exlibris.core.infra.model.filetable.HFileTable;
import com.exlibris.core.infra.svc.api.FileTableManager;
import com.exlibris.core.infra.svc.api.config.InfraConfigurationManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.digitool.repository.conf.xmlbeans.DataSource;
import com.exlibris.digitool.repository.conf.xmlbeans.DataSourceParameter;
import com.exlibris.digitool.repository.conf.xmlbeans.DataSourceParameters;
import com.exlibris.digitool.repository.conf.xmlbeans.DataSources;
import com.exlibris.digitool.repository.conf.xmlbeans.DeService;
import com.exlibris.digitool.repository.conf.xmlbeans.DeServices;
import com.exlibris.digitool.repository.conf.xmlbeans.Metadata;
import com.exlibris.digitool.repository.conf.xmlbeans.Metadatas;
import com.exlibris.digitool.repository.conf.xmlbeans.RpConfigurationDocument;
import com.exlibris.digitool.repository.conf.xmlbeans.SendMessage;
import com.exlibris.digitool.repository.conf.xmlbeans.SendMessages;
import com.exlibris.digitool.repository.conf.xmlbeans.SupportedSchemas;
import com.exlibris.digitool.repository.conf.xmlbeans.Transformer;
import com.exlibris.digitool.repository.conf.xmlbeans.Transformers;
import com.exlibris.digitool.repository.unitConf.xmlbeans.AccessRight;
import com.exlibris.digitool.repository.unitConf.xmlbeans.Parameter;
import com.exlibris.digitool.repository.unitConf.xmlbeans.Parameters;
import com.exlibris.digitool.repository.unitConf.xmlbeans.UnitConfigurationDocument;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class CoreConfigurationManager
extends InfraConfigurationManager
implements Resettable {
    public static final String ANY = "any";
    protected static final ExLogger log = ExLogger.getExLogger(CoreConfigurationManager.class);
    protected static CoreConfigurationManager rpc;
    protected RpConfigurationDocument rpcd = null;
    protected final Map mdType2nsmap = new Hashtable();
    protected final Hashtable name2Metadata = new Hashtable();
    protected final Hashtable id2Metadata = new Hashtable();
    protected final Hashtable transformersHash = new Hashtable();
    protected final Hashtable accessRightsHash = new Hashtable();
    protected final Hashtable desHash = new Hashtable();
    protected final Hashtable sendHash = new Hashtable();
    protected final Hashtable dataSourcesHash = new Hashtable();
    protected final Hashtable unitConfigurationHash = new Hashtable();
    protected boolean isDepositAllowed = true;
    protected boolean isCollMngAllowed = true;
    protected boolean isJpeg2000 = true;
    protected boolean useObjectCache = false;
    protected int maxObjectAllowed = 0;
    protected int repositoryObjectCount = 0;
    protected static final String RP_CONF_FILE = "com.exlibris.dps.repository.configuration";

    protected CoreConfigurationManager() {
        this.load();
    }

    public static synchronized CoreConfigurationManager getInstance() {
        if (rpc == null) {
            rpc = new CoreConfigurationManager();
        }
        return rpc;
    }

    @Override
    public synchronized void reset() {
        this.isInit = false;
        super.reset();
        this.load();
    }

    public static void main(String[] args) {
        CoreConfigurationManager.getInstance();
    }

    public void hashMds(Metadata[] md) {
        this.name2Metadata.clear();
        this.id2Metadata.clear();
        this.mdType2nsmap.clear();
        for (int i = 0; i < md.length; ++i) {
            this.name2Metadata.put(md[i].getName() + "~" + md[i].getType(), md[i]);
            this.id2Metadata.put(new Integer(md[i].getId()), md[i]);
            SupportedSchemas[] sch = md[i].getSupportedSchemasArray();
            if (sch == null || sch.length <= 0) continue;
            HashMap<String, String> m = null;
            m = new HashMap<String, String>();
            for (int j = 0; j < sch.length; ++j) {
                SupportedSchemas schemas = sch[j];
                m.put(schemas.getNamespaceUri(), schemas.getNamespacePrefix());
            }
            this.mdType2nsmap.put(md[i].getType(), m);
        }
    }

    protected void hashMds() {
        Metadatas mds = this.rpcd.getRpConfiguration().getMetadatas();
        if (mds == null) {
            return;
        }
        Metadata[] md = mds.getMetadataArray();
        for (int i = 0; i < md.length; ++i) {
            this.name2Metadata.put(md[i].getName() + "~" + md[i].getType(), md[i]);
            this.id2Metadata.put(new Integer(md[i].getId()), md[i]);
            SupportedSchemas[] sch = md[i].getSupportedSchemasArray();
            if (sch == null || sch.length <= 0) continue;
            HashMap<String, String> m = null;
            m = new HashMap<String, String>();
            for (int j = 0; j < sch.length; ++j) {
                SupportedSchemas schemas = sch[j];
                m.put(schemas.getNamespaceUri(), schemas.getNamespacePrefix());
            }
            this.mdType2nsmap.put(md[i].getType(), m);
        }
    }

    public Map getNamespacesByMetadataType(String metadataType) {
        return (Map)this.mdType2nsmap.get(metadataType);
    }

    public String getNamespacePrefix(String metadataType, String namespaceUri) {
        return (String)this.getNamespacesByMetadataType(metadataType).get(namespaceUri);
    }

    protected void hashTransformers() {
        Transformers transformers = this.rpcd.getRpConfiguration().getTransformers();
        if (transformers == null) {
            return;
        }
        Transformer[] tf = transformers.getTransformerArray();
        for (int i = 0; i < tf.length; ++i) {
            this.transformersHash.put(new Integer(tf[i].getId()), tf[i].copy());
        }
    }

    protected void hashDeServices() {
        DeServices deServices = this.rpcd.getRpConfiguration().getDeServices();
        if (deServices == null) {
            return;
        }
        DeService[] des = deServices.getDeServiceArray();
        for (int i = 0; i < des.length; ++i) {
            this.desHash.put(des[i].getName(), des[i].copy());
        }
    }

    public DeService[] getDeServices() {
        return this.desHash.values().toArray(new DeService[0]);
    }

    protected void hashDataSources() {
        DataSources dataSources = this.rpcd.getRpConfiguration().getDataSources();
        if (dataSources == null) {
            return;
        }
        DataSource[] ds = dataSources.getDataSourceArray();
        for (int i = 0; i < ds.length; ++i) {
            this.dataSourcesHash.put(new Integer(ds[i].getId()), ds[i].copy());
        }
    }

    public String getDataSourceParameter(int id, String key) throws Exception {
        boolean cont = true;
        String val = null;
        DataSource ds = this.getDataSource(id);
        DataSourceParameters parameters = ds.getDataSourceParameters();
        if (parameters == null) {
            return null;
        }
        for (int i = 0; i < parameters.sizeOfDataSourceParameterArray() && cont; ++i) {
            DataSourceParameter parameter = parameters.getDataSourceParameterArray(i);
            if (!key.equals(parameter.getName())) continue;
            val = parameter.getStringValue().trim();
            cont = false;
        }
        return val;
    }

    public DataSource getDataSource(int id) throws Exception {
        DataSource ds = (DataSource)this.dataSourcesHash.get(new Integer(id));
        if (ds == null) {
            throw new RuntimeException("DataSource not defined in conf.xml: id = " + id);
        }
        return ds;
    }

    protected void hashSendMessage() {
        SendMessages sendMessages = this.rpcd.getRpConfiguration().getSendMessages();
        if (sendMessages == null) {
            log.info("Message notification is disabled.");
            return;
        }
        SendMessage[] send = sendMessages.getSendMessageArray();
        for (int i = 0; i < send.length; ++i) {
            log.info(send[i].getType() + " message is enabled.");
            this.sendHash.put(send[i].getType(), send[i].copy());
        }
    }

    public SendMessage getSendMessage(String type) {
        return (SendMessage)this.sendHash.get(type);
    }

    public AccessRight getAccessRight(String name) throws Exception {
        try {
            AccessRight ar = (AccessRight)this.accessRightsHash.get(name);
            if (ar != null) {
                ar = (AccessRight)ar.copy();
            }
            if (ar == null) {
                throw new RuntimeException("AccessRight is not defined in unit_configuration.xml: name=" + name);
            }
            return ar;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public Transformer getTransformer(int id) throws Exception {
        Transformer tf = (Transformer)this.transformersHash.get(new Integer(id));
        if (tf == null) {
            throw new RuntimeException("Transformer not defined in conf.xml: id=" + id);
        }
        return tf;
    }

    public Transformer[] getTransformers() {
        return this.transformersHash.values().toArray(new Transformer[0]);
    }

    public Metadata getMetadataInfoByNameAndType(String mdName, String mdType) throws Exception {
        if (mdName == null) {
            throw new RuntimeException("Missing metadata name.");
        }
        if (mdType == null) {
            throw new RuntimeException("Missing metadata type.");
        }
        Metadata confMd = this.getMetadataInfo(mdName, mdType);
        return confMd;
    }

    protected Metadata getMetadataInfo(String mdName, String mdType) throws Exception {
        Metadata conf_md = (Metadata)this.name2Metadata.get(mdName + "~" + mdType);
        if (conf_md == null) {
            throw new RuntimeException("Metadata not defined in conf.xml: name=" + mdName + ", type=" + mdType);
        }
        return conf_md;
    }

    public Metadata getMetadataById(int id) throws Exception {
        Metadata md = (Metadata)this.id2Metadata.get(new Integer(id));
        if (md == null) {
            throw new RuntimeException("Metadata not defined in conf.xml: id=" + id);
        }
        return md;
    }

    public Metadata getMetadataByNameAndType(String mdName, String mdType) {
        if (mdName == null || mdType == null) {
            return null;
        }
        Metadata md = (Metadata)this.name2Metadata.get(mdName + "~" + mdType);
        return md;
    }

    public int getLastMetadataID() {
        int max = 0;
        int tmp = 0;
        Enumeration enums = this.id2Metadata.keys();
        while (enums.hasMoreElements()) {
            tmp = (Integer)enums.nextElement();
            if (max >= tmp) continue;
            max = tmp;
        }
        return max;
    }

    protected void load() {
        try {
            log.info("Looking for configuration file: com.exlibris.dps.repository.configuration ...");
            FileTableManager manager = (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
            HFileTable confFile = manager.getFileByKey(RP_CONF_FILE);
            log.info("Configuration file found.");
            this.rpcd = RpConfigurationDocument.Factory.parse(confFile.getFile());
            this.hashMds();
            this.hashTransformers();
            this.hashDeServices();
            this.hashSendMessage();
            this.hashDataSources();
            this.initLicense();
            this.initSpecialParameters();
            this.initNetwork();
            this.isInit = true;
            log.info("Setting Loaded");
        }
        catch (Throwable e) {
            String err = "Failed to load configuration from com.exlibris.dps.repository.configuration: " + e.getMessage();
            log.error(err, e, new String[0]);
            this.isInit = false;
            throw new RuntimeException(err, e);
        }
    }

    private void initNetwork() {
        int conTimeout = 2000;
        int readTimeout = 2000;
        String useProxy = "false";
        String proxyHost = "";
        String proxyPort = "";
        String proxyUser = "";
        String proxyPass = "";
        try {
            String conTimeoutStr = this.getParameter("network", "external_connection_timeout");
            if (conTimeoutStr != null && conTimeoutStr.length() < 1) {
                conTimeout = -1;
            } else {
                conTimeout = Integer.parseInt(conTimeoutStr);
                conTimeout *= 1000;
            }
        }
        catch (Exception conTimeoutStr) {
            // empty catch block
        }
        try {
            String readTimeoutStr = this.getParameter("network", "external_read_timeout");
            if (readTimeoutStr != null && readTimeoutStr.length() < 1) {
                readTimeout = -1;
            } else {
                readTimeout = Integer.parseInt(readTimeoutStr);
                readTimeout *= 1000;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (conTimeout > 0) {
            System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(conTimeout));
        } else {
            System.setProperty("sun.net.client.defaultConnectTimeout", "-1");
        }
        if (readTimeout > 0) {
            System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(readTimeout));
        } else {
            System.setProperty("sun.net.client.defaultReadTimeout", "-1");
        }
        try {
            useProxy = this.getParameter("network", "use_proxy");
            proxyHost = this.getParameter("network", "proxy_host");
            proxyPort = this.getParameter("network", "proxy_port");
            proxyUser = this.getParameter("network", "proxy_user");
            proxyPass = this.getParameter("network", "proxy_pass");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Boolean.valueOf(useProxy).booleanValue()) {
            System.setProperty("proxySet", "true");
            if (proxyHost != null && proxyHost.length() > 0) {
                System.setProperty("http.proxyHost", proxyHost);
            }
            if (proxyPort != null && proxyPort.length() > 0) {
                System.setProperty("http.proxyPort", proxyPort);
            }
            if (proxyUser != null && proxyUser.length() > 0) {
                System.setProperty("http.proxyUser", proxyUser);
            }
            if (proxyPass != null && proxyPass.length() > 0) {
                System.setProperty("http.proxyPassword", proxyPass);
            }
        } else {
            System.setProperty("proxySet", "false");
        }
        log.info("defaultConnectTimeout - " + System.getProperty("sun.net.client.defaultConnectTimeout"));
        log.info("defaultReadTimeout - " + System.getProperty("sun.net.client.defaultReadTimeout"));
    }

    private void initSpecialParameters() {
        String useCacheStr = null;
        try {
            useCacheStr = this.getParameter("repository", "cache_mode");
            this.useObjectCache = useCacheStr != null && useCacheStr.length() < 1 ? false : Boolean.valueOf(useCacheStr.toLowerCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RpConfigurationDocument.RpConfiguration getSettings() {
        if (this.isInit) {
            return this.rpcd.getRpConfiguration();
        }
        return null;
    }

    public String getDigitoolHome() {
        String home = System.getProperty("digitool.home");
        if (home == null) {
            return null;
        }
        if (!home.endsWith("/") && !home.endsWith("\\")) {
            home = home + "/";
        }
        home = home + "../";
        return home;
    }

    public RpConfigurationDocument getRpConfigurationDocument() {
        return this.rpcd;
    }

    private void initLicense() {
        this.setCollMngAllowed(true);
        this.setDepositAllowed(true);
        this.setJpeg2000(true);
        this.setMaxObjectAllowed(1000000);
        log.info("COLLMNG licensed - " + this.isCollMngAllowed());
        log.info("DEPOSIT licensed - " + this.isDepositAllowed());
        log.info("JPEG2000 licensed - " + this.isJpeg2000());
        log.info("MAX-OBJECT-COUNT licensed - " + this.getMaxObjectAllowed());
    }

    public boolean isCollMngAllowed() {
        if (this.isDevelopmentMode()) {
            return true;
        }
        return this.isCollMngAllowed;
    }

    public void setCollMngAllowed(boolean isCollMngAllowed) {
        this.isCollMngAllowed = isCollMngAllowed;
    }

    public boolean isDepositAllowed() {
        if (this.isDevelopmentMode()) {
            return true;
        }
        return this.isDepositAllowed;
    }

    public void setDepositAllowed(boolean isDepositAllowed) {
        this.isDepositAllowed = isDepositAllowed;
    }

    public boolean isMaxObjectsExceeded() {
        if (this.isDevelopmentMode()) {
            return false;
        }
        return this.getMaxObjectAllowed() - this.getRepositoryObjectCount() < 0;
    }

    public int getMaxObjectAllowed() {
        return this.maxObjectAllowed;
    }

    public void setMaxObjectAllowed(int maxObjectAllowed) {
        this.maxObjectAllowed = maxObjectAllowed;
    }

    public int getRepositoryObjectCount() {
        return this.repositoryObjectCount;
    }

    public void setRepositoryObjectCount(int repositoryObjectCount) {
        this.repositoryObjectCount = repositoryObjectCount;
    }

    public boolean isJpeg2000() {
        return this.isJpeg2000;
    }

    public void setJpeg2000(boolean isJpeg2000) {
        this.isJpeg2000 = isJpeg2000;
    }

    public boolean isObjectCacheMode() {
        return this.useObjectCache;
    }

    public void setObjectCacheMode(boolean useObjectCache) {
        this.useObjectCache = useObjectCache;
    }

    public UnitConfigurationDocument getUnitConfigurationDocument(String adminUnit) {
        return (UnitConfigurationDocument)this.unitConfigurationHash.get(adminUnit);
    }

    public Parameter[] getUnitConfigurationParameters(String adminUnit) {
        Parameters unitParameters = null;
        UnitConfigurationDocument unitConfigurationDocument = this.getUnitConfigurationDocument(adminUnit);
        if (unitConfigurationDocument == null || unitConfigurationDocument.getUnitConfiguration() == null) {
            return null;
        }
        unitParameters = unitConfigurationDocument.getUnitConfiguration().getParameters();
        if (unitParameters == null || unitParameters.getParameterArray() == null) {
            return null;
        }
        return unitParameters.getParameterArray();
    }

    protected Object parseXmlBean(String className, InputStream xmlStream) {
        try {
            Class<?> beanClass = Class.forName(className);
            Class<?>[] classArray = beanClass.getClasses();
            Class<?> factoryClass = null;
            Object xmlBean = null;
            for (int i = 0; i < classArray.length && factoryClass == null; ++i) {
                Class<?> currClass = classArray[i];
                if (!currClass.getSimpleName().equals("Factory")) continue;
                factoryClass = currClass;
            }
            if (factoryClass != null) {
                Method parseMethod = factoryClass.getDeclaredMethod("parse", InputStream.class);
                xmlBean = parseMethod.invoke(null, xmlStream);
            }
            return xmlBean;
        }
        catch (Exception e) {
            log.error("Can't parse XML Bean: " + e.toString(), e, new String[0]);
            return null;
        }
    }
}

