/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.sdk.utils.DepositDirUtil;
import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.core.sdk.utils.SipDirUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class LoadDirUtil {
    private final GregorianCalendar m_calendar = new GregorianCalendar();
    private StringBuffer m_buffer = null;
    private String m_folderId = null;
    private String m_folderDir = null;
    private SipDirUtil m_sipUtil = null;
    private DepositDirUtil m_depositUtil = null;
    private final Hashtable m_fosHash = new Hashtable();
    private BufferedReader portionReader;

    protected LoadDirUtil(String folderDir, String folderId) {
        this.m_folderId = folderId;
        this.m_buffer = new StringBuffer(100);
        this.m_folderDir = this.m_buffer.append(folderDir).append(this.getFolderPrefix()).append(this.m_folderId).append(FSUtil.SEPARATOR).toString();
        this.m_sipUtil = new SipDirUtil(this.m_folderDir, "");
        this.m_depositUtil = new DepositDirUtil(this.m_folderDir, "");
    }

    String getFolderPrefix() {
        return "load_";
    }

    public boolean isExists() {
        File f = new File(this.m_folderDir);
        return f.exists();
    }

    public String getFolderDir() {
        return this.m_folderDir;
    }

    public boolean createNewDirStructure() {
        FileUtil.createFile(this.m_folderDir);
        this.m_depositUtil.createNewDirStructure();
        this.m_sipUtil.createNewDirStructure();
        return true;
    }

    public SipDirUtil getSipDirUtil() {
        return this.m_sipUtil;
    }

    public DepositDirUtil getDepositDirUtil() {
        return this.m_depositUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFile(String relativePath, String fileName, InputStream doc) throws IOException {
        if (this.m_folderDir == null) {
            return false;
        }
        File nFile = new File(this.m_folderDir + relativePath);
        if (!nFile.exists()) {
            nFile.mkdirs();
        }
        try (BufferedOutputStream bof = new BufferedOutputStream(new FileOutputStream(nFile.getAbsolutePath() + "/" + fileName));){
            IOUtil.copy(doc, (OutputStream)bof);
        }
        return true;
    }

    public void writeMsgInternal(String msg, String fileName, boolean append, boolean closeFile, boolean writeToConsole) {
        BufferedOutputStream fos = (BufferedOutputStream)this.m_fosHash.get(fileName);
        if (fos == null) {
            try {
                fos = new BufferedOutputStream(new FileOutputStream(this.m_folderDir + fileName, append));
            }
            catch (Exception e) {
                System.out.println("Fail to init log file:" + this.m_folderDir + fileName);
            }
        }
        try {
            StringBuffer fullMsg = new StringBuffer(DateHandler.formatDateAndTime(new Date())).append(" : ").append(msg).append("\n");
            IOUtil.copy(fullMsg.toString(), (OutputStream)fos);
            if (writeToConsole) {
                System.out.print(fullMsg);
            }
            if (!closeFile) {
                this.m_fosHash.put(fileName, fos);
            } else {
                fos.close();
            }
        }
        catch (IOException e1) {
            System.out.println("Fail writing message to log:" + msg);
        }
    }

    public void close() {
        Enumeration enums = this.m_fosHash.elements();
        while (enums.hasMoreElements()) {
            BufferedOutputStream fos = (BufferedOutputStream)enums.nextElement();
            if (fos == null) continue;
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void deleteDirStructure() throws IOException {
        FileUtil.forceDelete(this.m_folderDir);
    }

    public String getFolderId() {
        return this.m_folderId;
    }
}

