/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.factory;

import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.locator.WebServiceLocator;
import com.exlibris.dps.sdk.deposit.DepositWebServices;

public class DepositWSFactory {
    public static final DepositWebServices create(String wsdl) {
        boolean isDemo = false;
        try {
            isDemo = new Boolean(GlobalProperties.getInstance().getProperty("rosetta_ws_demo_mode"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isDemo) {
            return DepositWSFactory.createDemo(wsdl);
        }
        return DepositWSFactory.createWS(wsdl);
    }

    public static final DepositWebServices createDemo(String wsdl) {
        try {
            return (DepositWebServices)Class.forName("com.exlibris.dps.demo.impl.DepositServicesImpl").newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return DepositWSFactory.createWS(wsdl);
        }
    }

    public static final DepositWebServices createWS(String wsdl) {
        return WebServiceLocator.getInstance().lookUp(DepositWebServices.class, wsdl);
    }
}

