/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.PsychoPathTypeHelper;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CommentType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.PIType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.SchemaTypeValueFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.TextType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public abstract class NodeType
extends AnyType {
    protected static final String SCHEMA_TYPE_IDREF = "IDREF";
    protected static final String SCHEMA_TYPE_ID = "ID";
    private Node _node;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public NodeType(Node node) {
        this._node = node;
    }

    public Node node_value() {
        return this._node;
    }

    public abstract ResultSequence typed_value();

    public abstract QName node_name();

    public ResultSequence nilled() {
        return ResultSequenceFactory.create_new();
    }

    public static NodeType dom_to_xpath(Node node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        switch (node.getNodeType()) {
            case 1: {
                return new ElementType((Element)node);
            }
            case 8: {
                return new CommentType((Comment)node);
            }
            case 2: {
                return new AttrType((Attr)node);
            }
            case 3: {
                return new TextType((Text)node);
            }
            case 9: {
                return new DocType((Document)node);
            }
            case 7: {
                return new PIType((ProcessingInstruction)node);
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static ResultSequence eliminate_dups(ResultSequence rs) {
        Hashtable<Node, Boolean> added = new Hashtable<Node, Boolean>(rs.size());
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType node = (NodeType)i.next();
            Node n = node.node_value();
            if (added.containsKey(n)) {
                i.remove();
                continue;
            }
            added.put(n, Boolean.TRUE);
        }
        return rs;
    }

    public static ResultSequence sort_document_order(ResultSequence rs) {
        NodeType node;
        ArrayList<NodeType> res = new ArrayList<NodeType>(rs.size());
        Iterator i = rs.iterator();
        while (i.hasNext()) {
            node = (NodeType)i.next();
            boolean added = false;
            int j = 0;
            while (j < res.size()) {
                NodeType x = (NodeType)res.get(j);
                if (NodeType.before(node, x)) {
                    res.add(j, node);
                    added = true;
                    break;
                }
                ++j;
            }
            if (added) continue;
            res.add(node);
        }
        rs = ResultSequenceFactory.create_new();
        i = res.iterator();
        while (i.hasNext()) {
            node = (NodeType)i.next();
            rs.add(node);
        }
        return rs;
    }

    public static boolean same(NodeType a, NodeType b) {
        return a.node_value().isSameNode(b.node_value());
    }

    public boolean before(NodeType two) {
        return NodeType.before(this, two);
    }

    public static boolean before(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) < 0;
    }

    public boolean after(NodeType two) {
        return NodeType.after(this, two);
    }

    public static boolean after(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) > 0;
    }

    private static int compare_node(NodeType a, NodeType b) {
        Document docB;
        Node nodeB;
        Node nodeA = a.node_value();
        if (nodeA == (nodeB = b.node_value()) || nodeA.isSameNode(nodeB)) {
            return 0;
        }
        Document docA = NodeType.getDocument(nodeA);
        if (docA != (docB = NodeType.getDocument(nodeB)) && !docA.isSameNode(docB)) {
            return NodeType.compareDocuments(docA, docB);
        }
        short relation = nodeA.compareDocumentPosition(nodeB);
        if ((relation & 2) != 0) {
            return 1;
        }
        if ((relation & 4) != 0) {
            return -1;
        }
        throw new RuntimeException("Unexpected result from node comparison: " + relation);
    }

    private static int compareDocuments(Document docA, Document docB) {
        if (docB.getDocumentURI() == null && docA.getDocumentURI() == null) {
            return 0;
        }
        return docB.getDocumentURI().compareTo(docA.getDocumentURI());
    }

    private static Document getDocument(Node nodeA) {
        return nodeA instanceof Document ? (Document)nodeA : nodeA.getOwnerDocument();
    }

    protected Object getTypedValueForPrimitiveType(XSTypeDefinition typeDef) {
        String strValue = this.string_value();
        if (typeDef == null) {
            return new XSUntypedAtomic(strValue);
        }
        return SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode(typeDef), strValue);
    }

    protected ResultSequence getXDMTypedValue(XSTypeDefinition typeDef, ShortList itemValTypes) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if ("anySimpleType".equals(typeDef.getName()) || "anyAtomicType".equals(typeDef.getName())) {
            rs.add(new XSUntypedAtomic(this.string_value()));
        } else {
            XSSimpleTypeDefinition simpType = null;
            ResultSequence rsSimpleContent = null;
            if (typeDef instanceof XSComplexTypeDefinition) {
                XSComplexTypeDefinition complexTypeDefinition = (XSComplexTypeDefinition)typeDef;
                simpType = complexTypeDefinition.getSimpleType();
                if (simpType != null) {
                    rsSimpleContent = this.getTypedValueForSimpleContent(simpType, itemValTypes);
                } else {
                    rs.add(new XSUntypedAtomic(this.string_value()));
                }
            } else {
                simpType = (XSSimpleTypeDefinition)typeDef;
                rsSimpleContent = this.getTypedValueForSimpleContent(simpType, itemValTypes);
            }
            if (rsSimpleContent != null) {
                rs = rsSimpleContent;
            }
        }
        return rs;
    }

    private ResultSequence getTypedValueForSimpleContent(XSSimpleTypeDefinition simpType, ShortList itemValueTypes) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (simpType.getVariety() == 1) {
            AnyType schemaTypeValue = SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode((XSTypeDefinition)simpType), this.string_value());
            if (schemaTypeValue != null) {
                rs.add(schemaTypeValue);
            } else {
                rs.add(new XSUntypedAtomic(this.string_value()));
            }
        } else if (simpType.getVariety() == 2) {
            this.addAtomicListItemsToResultSet(simpType, itemValueTypes, rs);
        } else if (simpType.getVariety() == 3) {
            this.getTypedValueForVarietyUnion(simpType, rs);
        }
        return rs;
    }

    private void addAtomicListItemsToResultSet(XSSimpleTypeDefinition simpType, ShortList itemValueTypes, ResultSequence rs) {
        block3: {
            XSSimpleTypeDefinition itemType;
            String[] listItemsStrValues;
            block2: {
                listItemsStrValues = this.string_value().split("\\s+");
                itemType = simpType.getItemType();
                if (itemType.getVariety() != 1) break block2;
                int listItemIdx = 0;
                while (listItemIdx < listItemsStrValues.length) {
                    rs.add(SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode((XSTypeDefinition)itemType), listItemsStrValues[listItemIdx]));
                    ++listItemIdx;
                }
                break block3;
            }
            if (itemType.getVariety() != 3) break block3;
            int listItemIdx = 0;
            while (listItemIdx < listItemsStrValues.length) {
                String listItem = listItemsStrValues[listItemIdx];
                rs.add(SchemaTypeValueFactory.newSchemaTypeValue(itemValueTypes.item(listItemIdx), listItem));
                ++listItemIdx;
            }
        }
    }

    private void getTypedValueForVarietyUnion(XSSimpleTypeDefinition simpType, ResultSequence rs) {
        XSObjectList memberTypes = simpType.getMemberTypes();
        int memTypeIdx = 0;
        while (memTypeIdx < memberTypes.getLength()) {
            XSSimpleType memSimpleType = (XSSimpleType)memberTypes.item(memTypeIdx);
            if (this.isValueValidForSimpleType(this.string_value(), memSimpleType)) {
                rs.add(SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode((XSTypeDefinition)memSimpleType), this.string_value()));
                break;
            }
            ++memTypeIdx;
        }
    }

    private boolean isValueValidForSimpleType(String value, XSSimpleType simplType) {
        boolean isValueValid = true;
        try {
            ValidatedInfo validatedInfo = new ValidatedInfo();
            ValidationState validationState = new ValidationState();
            simplType.validate(value, (ValidationContext)validationState, validatedInfo);
        }
        catch (InvalidDatatypeValueException ex) {
            isValueValid = false;
        }
        return isValueValid;
    }

    public abstract boolean isID();

    public abstract boolean isIDREF();

    protected boolean isType(TypeInfo typeInfo, String typeName) {
        String typeInfoName;
        return typeInfo != null && (typeInfoName = typeInfo.getTypeName()) != null && typeInfo.getTypeName().equalsIgnoreCase(typeName);
    }
}

