/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.base.security;

import com.exlibris.core.infra.base.security.CrossNetworkWorkflow;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class CustomerInstitutionRetriever {
    public static boolean tempDisableDebug = false;
    private static Map<Long, Map<String, Object>> debugInfo = new ConcurrentHashMap<Long, Map<String, Object>>();
    public static final String DBG_STR_SESSION = "STR_SESSION";
    public static final String DBG_START_PROCESSING_TIME = "DBG_START_PROCESSING_TIME";
    private static final Logger logger = Logger.getLogger(CustomerInstitutionRetriever.class);
    public static final String CONTEXT_CONSORTIA_USERS = "CONTEXT_CONSORTIA_USERS";
    public static final String CONTEXT_MD_EDITOR = "CONTEXT_MD_EDITOR";
    public static final ThreadLocal<Boolean> allowOnlineSilentLogin = new ThreadLocal();
    private static final ThreadLocal<String> onlineContext = new ThreadLocal();
    private static final ThreadLocal<CrossNetworkWorkflow> crossNetworkContext = new ThreadLocal();
    public static final ThreadLocal<Long> customerIdLocalThread = new ThreadLocal();
    public static final ThreadLocal<Long> institutionIdLocalThread = new ThreadLocal();
    public static final ThreadLocal<Principal> userPrincipalLocalThread = new ThreadLocal();
    public static final ThreadLocal<HttpServletRequest> httpServletRequestLocalThread = new ThreadLocal();

    public static void clear() {
        customerIdLocalThread.remove();
        institutionIdLocalThread.remove();
        userPrincipalLocalThread.remove();
        httpServletRequestLocalThread.remove();
        allowOnlineSilentLogin.remove();
        onlineContext.remove();
        crossNetworkContext.remove();
        MDC.remove((String)"inst");
        if (!tempDisableDebug) {
            CustomerInstitutionRetriever.removeDebugInfoForCurrentThread();
        }
    }

    public static void setInstitutionCustomerId(Long customerId, Long institutionId) {
        customerIdLocalThread.set(customerId);
        institutionIdLocalThread.set(institutionId);
        CustomerInstitutionRetriever.addDebugObjectForCurrentThread("STR_CUST_ID", customerId);
        CustomerInstitutionRetriever.addDebugObjectForCurrentThread("STR_INST_ID", institutionId);
    }

    public static Long getCustomerId() {
        return customerIdLocalThread.get();
    }

    public static Long getInstitutionId() {
        return institutionIdLocalThread.get();
    }

    public static void setServletRequest(HttpServletRequest request) {
        httpServletRequestLocalThread.set(request);
    }

    public static HttpServletRequest getServletRequest() {
        return httpServletRequestLocalThread.get();
    }

    public static void setPrincipal(Principal principal) {
        userPrincipalLocalThread.set(principal);
    }

    public static Principal getPrincipal() {
        return userPrincipalLocalThread.get();
    }

    public static Boolean isAllowedOnlineSilentLogin() {
        return BooleanUtils.isTrue((Boolean)allowOnlineSilentLogin.get());
    }

    public static void disableAllowedOnlineSilentLogin() {
        CustomerInstitutionRetriever.setAllowedOnlineSilentLogin(false);
    }

    public static void enableAllowedOnlineSilentLogin() {
        CustomerInstitutionRetriever.setAllowedOnlineSilentLogin(true);
    }

    private static void setAllowedOnlineSilentLogin(Boolean securityCheck) {
        allowOnlineSilentLogin.set(securityCheck);
    }

    public static String getOnlinecontext() {
        return onlineContext.get();
    }

    public static void setOnlinecontext(String context) {
        onlineContext.set(context);
    }

    public static void clearOnlineContext() {
        onlineContext.remove();
    }

    public static CrossNetworkWorkflow getCrossNetworkContext() {
        return crossNetworkContext.get();
    }

    public static void setCrossNetworkContext(CrossNetworkWorkflow context) {
        crossNetworkContext.set(context);
    }

    public static void clearCrossNetworkContext() {
        crossNetworkContext.remove();
    }

    private static long currentThreadId() {
        return Thread.currentThread().getId();
    }

    public static void addDebugObjectForCurrentThread(String name, Object value) {
        if (tempDisableDebug) {
            return;
        }
        Map<String, Object> map = debugInfo.get(CustomerInstitutionRetriever.currentThreadId());
        if (map == null) {
            map = new HashMap<String, Object>();
            map.put(DBG_START_PROCESSING_TIME, System.currentTimeMillis());
            debugInfo.put(CustomerInstitutionRetriever.currentThreadId(), map);
        }
        map.put(name, value);
    }

    public static void removeDebugInfoForCurrentThread() {
        debugInfo.remove(CustomerInstitutionRetriever.currentThreadId());
    }

    public static Map<String, Object> getDebugInfo(long threadId) {
        return debugInfo.get(threadId);
    }
}

